/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.model;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Extension;

public class ExtensionInfo {
    private final String extensionId;
    private final boolean critical;
    private final String value;

    public static Extension toExtension(ExtensionInfo extensionInfo) {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(extensionInfo.getExtensionId());
        byte[] extensionValue = extensionInfo.getValue().getBytes();
        DEROctetString value = new DEROctetString(extensionValue);
        return new Extension(oid, extensionInfo.isCritical(), (ASN1OctetString)value);
    }

    public static Extension[] toExtensions(ExtensionInfo[] extensionInfos) {
        Extension[] extensions = new Extension[extensionInfos.length];
        int i = 0;
        for (ExtensionInfo extensionInfo : extensionInfos) {
            extensions[i++] = ExtensionInfo.toExtension(extensionInfo);
        }
        return extensions;
    }

    public static ExtensionInfo fromExtension(Extension extension) {
        String extensionId = extension.getExtnId().getId();
        boolean critical = extension.isCritical();
        String value = new String(extension.getExtnValue().getOctets());
        return ((ExtensionInfoBuilder)((ExtensionInfoBuilder)((ExtensionInfoBuilder)ExtensionInfo.builder().extensionId(extensionId)).critical(critical)).value(value)).build();
    }

    public static List<ExtensionInfo> extractExtensionInfos(X509Certificate certificate) {
        Set<String> nonCriticalOIDs;
        ArrayList<ExtensionInfo> extensions = new ArrayList<ExtensionInfo>();
        Set<String> criticalOIDs = certificate.getCriticalExtensionOIDs();
        if (criticalOIDs != null) {
            for (String oid : criticalOIDs) {
                byte[] extensionValue = certificate.getExtensionValue(oid);
                Extension extension = new Extension(new ASN1ObjectIdentifier(oid), true, (ASN1OctetString)new DEROctetString(extensionValue));
                extensions.add(ExtensionInfo.fromExtension(extension));
            }
        }
        if ((nonCriticalOIDs = certificate.getNonCriticalExtensionOIDs()) != null) {
            for (String oid : nonCriticalOIDs) {
                byte[] extensionValue = certificate.getExtensionValue(oid);
                Extension extension = new Extension(new ASN1ObjectIdentifier(oid), false, (ASN1OctetString)new DEROctetString(extensionValue));
                extensions.add(ExtensionInfo.fromExtension(extension));
            }
        }
        return extensions;
    }

    public static ExtensionInfo[] extractToExtensionInfoArray(X509Certificate certificate) {
        return ExtensionInfo.extractExtensionInfos(certificate).toArray(new ExtensionInfo[0]);
    }

    @Generated
    protected ExtensionInfo(ExtensionInfoBuilder<?, ?> b) {
        this.extensionId = b.extensionId;
        this.critical = b.critical;
        this.value = b.value;
    }

    @Generated
    public static ExtensionInfoBuilder<?, ?> builder() {
        return new ExtensionInfoBuilderImpl();
    }

    @Generated
    public ExtensionInfoBuilder<?, ?> toBuilder() {
        return new ExtensionInfoBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getExtensionId() {
        return this.extensionId;
    }

    @Generated
    public boolean isCritical() {
        return this.critical;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionInfo)) {
            return false;
        }
        ExtensionInfo other = (ExtensionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCritical() != other.isCritical()) {
            return false;
        }
        String this$extensionId = this.getExtensionId();
        String other$extensionId = other.getExtensionId();
        if (this$extensionId == null ? other$extensionId != null : !this$extensionId.equals(other$extensionId)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtensionInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCritical() ? 79 : 97);
        String $extensionId = this.getExtensionId();
        result = result * 59 + ($extensionId == null ? 43 : $extensionId.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExtensionInfo(extensionId=" + this.getExtensionId() + ", critical=" + this.isCritical() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public ExtensionInfo(String extensionId, boolean critical, String value) {
        this.extensionId = extensionId;
        this.critical = critical;
        this.value = value;
    }

    @Generated
    public static abstract class ExtensionInfoBuilder<C extends ExtensionInfo, B extends ExtensionInfoBuilder<C, B>> {
        @Generated
        private String extensionId;
        @Generated
        private boolean critical;
        @Generated
        private String value;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ExtensionInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ExtensionInfo instance, ExtensionInfoBuilder<?, ?> b) {
            b.extensionId(instance.extensionId);
            b.critical(instance.critical);
            b.value(instance.value);
        }

        @Generated
        public B extensionId(String extensionId) {
            this.extensionId = extensionId;
            return this.self();
        }

        @Generated
        public B critical(boolean critical) {
            this.critical = critical;
            return this.self();
        }

        @Generated
        public B value(String value) {
            this.value = value;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ExtensionInfo.ExtensionInfoBuilder(extensionId=" + this.extensionId + ", critical=" + this.critical + ", value=" + this.value + ")";
        }
    }

    @Generated
    private static final class ExtensionInfoBuilderImpl
    extends ExtensionInfoBuilder<ExtensionInfo, ExtensionInfoBuilderImpl> {
        @Generated
        private ExtensionInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected ExtensionInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExtensionInfo build() {
            return new ExtensionInfo(this);
        }
    }
}

