/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.model;

import io.github.astrapi69.crypt.data.factory.KeyPairFactory;
import io.github.astrapi69.crypt.data.key.PrivateKeyExtensions;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import lombok.Generated;
import lombok.NonNull;

public class KeyPairInfo {
    private final String eCNamedCurveParameterSpecName;
    @NonNull
    private final String algorithm;
    private final String provider;
    private final int keySize;

    public static KeyPair toKeyPair(@NonNull KeyPairInfo keyPairInfo) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (keyPairInfo == null) {
            throw new NullPointerException("keyPairInfo is marked non-null but is null");
        }
        return KeyPairFactory.newKeyPair(keyPairInfo);
    }

    public static KeyPairInfo toKeyPairInfo(@NonNull KeyPair keyPair) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
        return ((KeyPairInfoBuilder)((KeyPairInfoBuilder)KeyPairInfo.builder().keySize(PrivateKeyExtensions.getKeyLength(keyPair.getPrivate()))).algorithm(keyPair.getPrivate().getAlgorithm())).build();
    }

    @Generated
    protected KeyPairInfo(KeyPairInfoBuilder<?, ?> b) {
        this.eCNamedCurveParameterSpecName = b.eCNamedCurveParameterSpecName;
        this.algorithm = b.algorithm;
        if (this.algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        this.provider = b.provider;
        this.keySize = b.keySize;
    }

    @Generated
    public static KeyPairInfoBuilder<?, ?> builder() {
        return new KeyPairInfoBuilderImpl();
    }

    @Generated
    public KeyPairInfoBuilder<?, ?> toBuilder() {
        return new KeyPairInfoBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getECNamedCurveParameterSpecName() {
        return this.eCNamedCurveParameterSpecName;
    }

    @NonNull
    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public int getKeySize() {
        return this.keySize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKeySize() != other.getKeySize()) {
            return false;
        }
        String this$eCNamedCurveParameterSpecName = this.getECNamedCurveParameterSpecName();
        String other$eCNamedCurveParameterSpecName = other.getECNamedCurveParameterSpecName();
        if (this$eCNamedCurveParameterSpecName == null ? other$eCNamedCurveParameterSpecName != null : !this$eCNamedCurveParameterSpecName.equals(other$eCNamedCurveParameterSpecName)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyPairInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getKeySize();
        String $eCNamedCurveParameterSpecName = this.getECNamedCurveParameterSpecName();
        result = result * 59 + ($eCNamedCurveParameterSpecName == null ? 43 : $eCNamedCurveParameterSpecName.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyPairInfo(eCNamedCurveParameterSpecName=" + this.getECNamedCurveParameterSpecName() + ", algorithm=" + this.getAlgorithm() + ", provider=" + this.getProvider() + ", keySize=" + this.getKeySize() + ")";
    }

    @Generated
    public KeyPairInfo(String eCNamedCurveParameterSpecName, @NonNull String algorithm, String provider, int keySize) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        this.eCNamedCurveParameterSpecName = eCNamedCurveParameterSpecName;
        this.algorithm = algorithm;
        this.provider = provider;
        this.keySize = keySize;
    }

    @Generated
    public static abstract class KeyPairInfoBuilder<C extends KeyPairInfo, B extends KeyPairInfoBuilder<C, B>> {
        @Generated
        private String eCNamedCurveParameterSpecName;
        @Generated
        private String algorithm;
        @Generated
        private String provider;
        @Generated
        private int keySize;

        @Generated
        protected B $fillValuesFrom(C instance) {
            KeyPairInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(KeyPairInfo instance, KeyPairInfoBuilder<?, ?> b) {
            b.eCNamedCurveParameterSpecName(instance.eCNamedCurveParameterSpecName);
            b.algorithm(instance.algorithm);
            b.provider(instance.provider);
            b.keySize(instance.keySize);
        }

        @Generated
        public B eCNamedCurveParameterSpecName(String eCNamedCurveParameterSpecName) {
            this.eCNamedCurveParameterSpecName = eCNamedCurveParameterSpecName;
            return this.self();
        }

        @Generated
        public B algorithm(@NonNull String algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm is marked non-null but is null");
            }
            this.algorithm = algorithm;
            return this.self();
        }

        @Generated
        public B provider(String provider) {
            this.provider = provider;
            return this.self();
        }

        @Generated
        public B keySize(int keySize) {
            this.keySize = keySize;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "KeyPairInfo.KeyPairInfoBuilder(eCNamedCurveParameterSpecName=" + this.eCNamedCurveParameterSpecName + ", algorithm=" + this.algorithm + ", provider=" + this.provider + ", keySize=" + this.keySize + ")";
        }
    }

    @Generated
    private static final class KeyPairInfoBuilderImpl
    extends KeyPairInfoBuilder<KeyPairInfo, KeyPairInfoBuilderImpl> {
        @Generated
        private KeyPairInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected KeyPairInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KeyPairInfo build() {
            return new KeyPairInfo(this);
        }
    }
}

