/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.model;

import io.github.astrapi69.crypt.data.factory.KeyStoreFactory;
import io.github.astrapi69.file.create.FileInfo;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;

public class KeyStoreInfo {
    @NonNull
    private final FileInfo fileInfo;
    @NonNull
    private final String type;
    @NonNull
    private final char[] keystorePassword;

    public static KeyStore toKeyStore(KeyStoreInfo keyStoreInfo) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return KeyStoreFactory.newKeyStore(keyStoreInfo);
    }

    @Generated
    protected KeyStoreInfo(KeyStoreInfoBuilder<?, ?> b) {
        this.fileInfo = b.fileInfo;
        if (this.fileInfo == null) {
            throw new NullPointerException("fileInfo is marked non-null but is null");
        }
        this.type = b.type;
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.keystorePassword = b.keystorePassword;
        if (this.keystorePassword == null) {
            throw new NullPointerException("keystorePassword is marked non-null but is null");
        }
    }

    @Generated
    public static KeyStoreInfoBuilder<?, ?> builder() {
        return new KeyStoreInfoBuilderImpl();
    }

    @Generated
    public KeyStoreInfoBuilder<?, ?> toBuilder() {
        return new KeyStoreInfoBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyStoreInfo)) {
            return false;
        }
        KeyStoreInfo other = (KeyStoreInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileInfo this$fileInfo = this.getFileInfo();
        FileInfo other$fileInfo = other.getFileInfo();
        if (this$fileInfo == null ? other$fileInfo != null : !this$fileInfo.equals(other$fileInfo)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return Arrays.equals(this.getKeystorePassword(), other.getKeystorePassword());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyStoreInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileInfo $fileInfo = this.getFileInfo();
        result = result * 59 + ($fileInfo == null ? 43 : $fileInfo.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeystorePassword());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyStoreInfo(fileInfo=" + this.getFileInfo() + ", type=" + this.getType() + ", keystorePassword=" + Arrays.toString(this.getKeystorePassword()) + ")";
    }

    @Generated
    public KeyStoreInfo(@NonNull FileInfo fileInfo, @NonNull String type, @NonNull char[] keystorePassword) {
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (keystorePassword == null) {
            throw new NullPointerException("keystorePassword is marked non-null but is null");
        }
        this.fileInfo = fileInfo;
        this.type = type;
        this.keystorePassword = keystorePassword;
    }

    @Generated
    public static abstract class KeyStoreInfoBuilder<C extends KeyStoreInfo, B extends KeyStoreInfoBuilder<C, B>> {
        @Generated
        private FileInfo fileInfo;
        @Generated
        private String type;
        @Generated
        private char[] keystorePassword;

        @Generated
        protected B $fillValuesFrom(C instance) {
            KeyStoreInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(KeyStoreInfo instance, KeyStoreInfoBuilder<?, ?> b) {
            b.fileInfo(instance.fileInfo);
            b.type(instance.type);
            b.keystorePassword(instance.keystorePassword);
        }

        @Generated
        public B fileInfo(@NonNull FileInfo fileInfo) {
            if (fileInfo == null) {
                throw new NullPointerException("fileInfo is marked non-null but is null");
            }
            this.fileInfo = fileInfo;
            return this.self();
        }

        @Generated
        public B type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this.self();
        }

        @Generated
        public B keystorePassword(@NonNull char[] keystorePassword) {
            if (keystorePassword == null) {
                throw new NullPointerException("keystorePassword is marked non-null but is null");
            }
            this.keystorePassword = keystorePassword;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "KeyStoreInfo.KeyStoreInfoBuilder(fileInfo=" + this.fileInfo + ", type=" + this.type + ", keystorePassword=" + Arrays.toString(this.keystorePassword) + ")";
        }
    }

    @Generated
    private static final class KeyStoreInfoBuilderImpl
    extends KeyStoreInfoBuilder<KeyStoreInfo, KeyStoreInfoBuilderImpl> {
        @Generated
        private KeyStoreInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected KeyStoreInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KeyStoreInfo build() {
            return new KeyStoreInfo(this);
        }
    }
}

