/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.obfuscation.rule;

import io.github.astrapi69.collection.set.SetFactory;
import io.github.astrapi69.crypt.api.obfuscation.rule.Operation;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ObfuscationOperationRule<C, RW>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private C character;
    private Set<Integer> indexes = SetFactory.newHashSet((Object[])new Integer[0]);
    private boolean inverted;
    private Optional<C> operatedCharacter = Optional.empty();
    private Operation operation = Operation.NONE;
    private RW replaceWith;

    public ObfuscationOperationRule() {
    }

    public ObfuscationOperationRule(C character, Set<Integer> indexes, boolean inverted, Optional<C> operatedCharacter, Operation operation, RW replaceWith) {
        Objects.requireNonNull(character);
        Objects.requireNonNull(replaceWith);
        this.character = character;
        this.indexes = indexes;
        this.inverted = inverted;
        this.operatedCharacter = operatedCharacter;
        this.operation = operation;
        this.replaceWith = replaceWith;
    }

    public static <C, RW> ObfuscationOperationRuleBuilder<C, RW> builder() {
        return new ObfuscationOperationRuleBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObfuscationOperationRule)) {
            return false;
        }
        ObfuscationOperationRule other = (ObfuscationOperationRule)o;
        C this$character = this.getCharacter();
        C other$character = other.getCharacter();
        if (this$character == null ? other$character != null : !this$character.equals(other$character)) {
            return false;
        }
        Set<Integer> this$indexes = this.getIndexes();
        Set<Integer> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        if (this.isInverted() != other.isInverted()) {
            return false;
        }
        Optional<C> this$operatedCharacter = this.getOperatedCharacter();
        Optional<C> other$operatedCharacter = other.getOperatedCharacter();
        if (this$operatedCharacter == null ? other$operatedCharacter != null : !((Object)this$operatedCharacter).equals(other$operatedCharacter)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        RW this$replaceWith = this.getReplaceWith();
        RW other$replaceWith = other.getReplaceWith();
        return this$replaceWith == null ? other$replaceWith == null : this$replaceWith.equals(other$replaceWith);
    }

    public C getCharacter() {
        return this.character;
    }

    public void setCharacter(C character) {
        this.character = character;
    }

    public Set<Integer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Set<Integer> indexes) {
        this.indexes = indexes;
    }

    public Optional<C> getOperatedCharacter() {
        return this.operatedCharacter;
    }

    public void setOperatedCharacter(Optional<C> operatedCharacter) {
        this.operatedCharacter = operatedCharacter;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public RW getReplaceWith() {
        return this.replaceWith;
    }

    public void setReplaceWith(RW replaceWith) {
        this.replaceWith = replaceWith;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        C $character = this.getCharacter();
        result = result * 59 + ($character == null ? 43 : $character.hashCode());
        Set<Integer> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        result = result * 59 + (this.isInverted() ? 79 : 97);
        Optional<C> $operatedCharacter = this.getOperatedCharacter();
        result = result * 59 + ($operatedCharacter == null ? 43 : ((Object)$operatedCharacter).hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        RW $replaceWith = this.getReplaceWith();
        result = result * 59 + ($replaceWith == null ? 43 : $replaceWith.hashCode());
        return result;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public ObfuscationOperationRuleBuilder<C, RW> toBuilder() {
        return new ObfuscationOperationRuleBuilder().character(this.character).indexes(this.indexes).inverted(this.inverted).operatedCharacter(this.operatedCharacter).operation(this.operation).replaceWith(this.replaceWith);
    }

    public String toString() {
        return "ObfuscationOperationRule(character=" + this.getCharacter() + ", indexes=" + this.getIndexes() + ", inverted=" + this.isInverted() + ", operatedCharacter=" + this.getOperatedCharacter() + ", operation=" + this.getOperation() + ", replaceWith=" + this.getReplaceWith() + ")";
    }

    public static class ObfuscationOperationRuleBuilder<C, RW> {
        private C character;
        private Set<Integer> indexes = SetFactory.newHashSet((Object[])new Integer[0]);
        private boolean inverted;
        private Optional<C> operatedCharacter = Optional.empty();
        private Operation operation;
        private RW replaceWith;

        ObfuscationOperationRuleBuilder() {
        }

        public ObfuscationOperationRule<C, RW> build() {
            return new ObfuscationOperationRule<C, RW>(this.character, this.indexes, this.inverted, this.operatedCharacter, this.operation, this.replaceWith);
        }

        public ObfuscationOperationRuleBuilder<C, RW> character(C character) {
            Objects.requireNonNull(character);
            this.character = character;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> indexes(Set<Integer> indexes) {
            this.indexes = indexes;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> inverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> operatedCharacter(Optional<C> operatedCharacter) {
            this.operatedCharacter = operatedCharacter;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> replaceWith(RW replaceWith) {
            Objects.requireNonNull(replaceWith);
            this.replaceWith = replaceWith;
            return this;
        }

        public String toString() {
            return "ObfuscationOperationRule.ObfuscationOperationRuleBuilder(character=" + this.character + ", indexes=" + this.indexes + ", inverted=" + this.inverted + ", operatedCharacter=" + this.operatedCharacter + ", operation=" + this.operation + ", replaceWith=" + this.replaceWith + ")";
        }
    }
}

