/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapisixtynine.easy.logger;

import java.io.IOException;
import java.util.logging.LogManager;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class LoggingConfiguration {
    private LoggingConfiguration() {
    }

    public static void setup() {
        LogManager.getLogManager().reset();
        LoggingConfiguration.loadLoggingFile();
        LoggingConfiguration.setupJavaUtilLoggingToSlf4jBridge();
    }

    public static void setupJavaUtilLoggingToSlf4jBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public static void loadLoggingFile() {
        try {
            LogManager.getLogManager().readConfiguration(LoggingConfiguration.class.getClassLoader().getResourceAsStream("logging.properties"));
        }
        catch (IOException e) {
            System.err.println("Could not load logging properties file");
        }
    }
}

