/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.design.pattern.eventbus;

import io.github.astrapi69.design.pattern.observer.event.EventListener;
import io.github.astrapi69.design.pattern.observer.event.EventObject;
import io.github.astrapi69.design.pattern.observer.event.EventSource;
import io.github.astrapi69.design.pattern.observer.event.EventSubject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;

public final class BaseEventBus {
    private final Map<String, EventSource<?>> eventSources = new ConcurrentHashMap();
    private final String name;

    public BaseEventBus(String name) {
        this.name = name;
    }

    public <T> void register(@NonNull EventListener<EventObject<T>> listener, @NonNull Class<T> eventSourceTypeClass) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        EventSource<EventObject<T>> eventSource = this.getEventSource(eventSourceTypeClass);
        eventSource.add(listener);
    }

    public <T> void unregister(@NonNull EventListener<EventObject<T>> listener, @NonNull Class<T> eventSourceTypeClass) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        EventSource<EventObject<T>> eventSource = this.getEventSource(eventSourceTypeClass);
        eventSource.remove(listener);
        this.remove(eventSourceTypeClass);
    }

    public <T> void post(@NonNull T source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Class<?> eventSourceTypeClass = source.getClass();
        if (this.containsKey(eventSourceTypeClass)) {
            this.get(eventSourceTypeClass).fireEvent((Object)EventObject.of(source));
        }
    }

    private EventSource<?> get(String key) {
        return this.eventSources.get(key);
    }

    private boolean containsKey(String key) {
        return this.eventSources.containsKey(key);
    }

    private <T> boolean containsKey(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        return this.containsKey(eventSourceTypeClass.getSimpleName());
    }

    private <T> EventSource<EventObject<T>> getEventSource(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (!this.containsKey(eventSourceTypeClass)) {
            this.put(eventSourceTypeClass.getSimpleName(), (EventSource<?>)new EventSubject());
        }
        return this.get(eventSourceTypeClass.getSimpleName());
    }

    private <T> Optional<EventSource<EventObject<T>>> remove(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (this.containsKey(eventSourceTypeClass)) {
            String classSimpleName = eventSourceTypeClass.getSimpleName();
            EventSource<?> removedEventSource = this.eventSources.remove(classSimpleName);
            return Optional.of(removedEventSource);
        }
        return Optional.empty();
    }

    private <T> EventSource<EventObject<T>> get(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (this.containsKey(eventSourceTypeClass)) {
            String classSimpleName = eventSourceTypeClass.getSimpleName();
            EventSource<?> removedEventSource = this.eventSources.get(classSimpleName);
            return removedEventSource;
        }
        return null;
    }

    private synchronized EventSource<?> put(String key, EventSource<?> value) {
        return this.eventSources.put(key, value);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

