/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.design.pattern.eventbus;

import io.github.astrapi69.design.pattern.observer.event.EventListener;
import io.github.astrapi69.design.pattern.observer.event.EventObject;
import io.github.astrapi69.design.pattern.observer.event.EventSource;
import io.github.astrapi69.design.pattern.observer.event.EventSubject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public final class GenericEventBus {
    private static final Map<String, EventSource<?>> eventSources = new ConcurrentHashMap();

    private GenericEventBus() {
    }

    public static <T> void register(@NonNull EventListener<EventObject<T>> listener, @NonNull Class<T> eventSourceTypeClass) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        EventSource<EventObject<T>> eventSource = GenericEventBus.getEventSource(eventSourceTypeClass);
        eventSource.add(listener);
    }

    public static <T> void unregister(@NonNull EventListener<EventObject<T>> listener, @NonNull Class<T> eventSourceTypeClass) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        EventSource<EventObject<T>> eventSource = GenericEventBus.getEventSource(eventSourceTypeClass);
        eventSource.remove(listener);
        GenericEventBus.remove(eventSourceTypeClass);
    }

    public static <T> void post(@NonNull T source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Class<?> eventSourceTypeClass = source.getClass();
        if (GenericEventBus.containsKey(eventSourceTypeClass)) {
            GenericEventBus.get(eventSourceTypeClass).fireEvent((Object)EventObject.of(source));
        }
    }

    private static EventSource<?> get(String key) {
        return eventSources.get(key);
    }

    private static boolean containsKey(String key) {
        return eventSources.containsKey(key);
    }

    private static <T> boolean containsKey(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        return GenericEventBus.containsKey(eventSourceTypeClass.getSimpleName());
    }

    private static <T> EventSource<EventObject<T>> getEventSource(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (!GenericEventBus.containsKey(eventSourceTypeClass)) {
            GenericEventBus.put(eventSourceTypeClass.getSimpleName(), new EventSubject());
        }
        return GenericEventBus.get(eventSourceTypeClass.getSimpleName());
    }

    private static <T> Optional<EventSource<EventObject<T>>> remove(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (GenericEventBus.containsKey(eventSourceTypeClass)) {
            String classSimpleName = eventSourceTypeClass.getSimpleName();
            EventSource<?> removedEventSource = eventSources.remove(classSimpleName);
            return Optional.of(removedEventSource);
        }
        return Optional.empty();
    }

    private static <T> EventSource<EventObject<T>> get(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (GenericEventBus.containsKey(eventSourceTypeClass)) {
            String classSimpleName = eventSourceTypeClass.getSimpleName();
            EventSource<?> removedEventSource = eventSources.get(classSimpleName);
            return removedEventSource;
        }
        return null;
    }

    private static synchronized EventSource<?> put(String key, EventSource<?> value) {
        return eventSources.put(key, value);
    }
}

