/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.design.pattern.eventbus;

import io.github.astrapi69.design.pattern.observer.event.EventObject;
import io.github.astrapi69.design.pattern.observer.event.EventSource;
import io.github.astrapi69.design.pattern.observer.event.EventSubject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public final class GenericEventBus {
    private static final Map<String, EventSource<?>> eventSources = new HashMap();

    private GenericEventBus() {
    }

    public static EventSource<?> get(String key) {
        return eventSources.get(key);
    }

    public static boolean containsKey(String key) {
        return eventSources.containsKey(key);
    }

    public static <T> boolean containsKey(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        return eventSources.containsKey(eventSourceTypeClass.getSimpleName());
    }

    public static <T> EventSource<EventObject<T>> getEventSource(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (!GenericEventBus.containsKey(eventSourceTypeClass)) {
            GenericEventBus.put(eventSourceTypeClass.getSimpleName(), new EventSubject());
        }
        return GenericEventBus.get(eventSourceTypeClass.getSimpleName());
    }

    public static <T> Optional<EventSource<EventObject<T>>> remove(@NonNull Class<T> eventSourceTypeClass) {
        if (eventSourceTypeClass == null) {
            throw new NullPointerException("eventSourceTypeClass is marked non-null but is null");
        }
        if (GenericEventBus.containsKey(eventSourceTypeClass)) {
            EventSource<?> removedEventSource = eventSources.remove(eventSourceTypeClass.getSimpleName());
            return Optional.of(removedEventSource);
        }
        return Optional.empty();
    }

    public static synchronized EventSource<?> put(String key, EventSource<?> value) {
        return eventSources.put(key, value);
    }
}

