/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.compare;

import io.github.astrapi69.checksum.FileChecksumExtensions;
import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.file.compare.FileCompareResultBean;
import io.github.astrapi69.file.compare.FileContentResultBean;
import io.github.astrapi69.file.compare.api.IFileCompareResultBean;
import io.github.astrapi69.file.compare.api.IFileContentResultBean;
import io.github.astrapi69.file.search.FileSearchExtensions;
import io.github.astrapi69.io.StreamExtensions;
import io.github.astrapi69.io.file.FilenameExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class CompareFileExtensions {
    private CompareFileExtensions() {
    }

    public static void compare(IFileCompareResultBean fileCompareResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        File source = fileCompareResultBean.getSourceFile();
        File compare = fileCompareResultBean.getFileToCompare();
        if (!ignoreAbsolutePathEquality) {
            String sourceAbsolutePath = source.getAbsolutePath();
            String compareAbsolutePath = compare.getAbsolutePath();
            boolean absolutePathEquality = sourceAbsolutePath.equals(compareAbsolutePath);
            fileCompareResultBean.setAbsolutePathEquality(absolutePathEquality);
        } else {
            fileCompareResultBean.setAbsolutePathEquality(true);
        }
        if (!ignoreExtensionEquality) {
            String sourceFileExtension = FilenameExtensions.getFilenameSuffix((File)source);
            String compareFileExtension = FilenameExtensions.getFilenameSuffix((File)compare);
            boolean extensionEquality = compareFileExtension.equalsIgnoreCase(sourceFileExtension);
            fileCompareResultBean.setFileExtensionEquality(extensionEquality);
        } else {
            fileCompareResultBean.setFileExtensionEquality(true);
        }
        if (!ignoreLengthEquality) {
            boolean length = source.length() == compare.length();
            fileCompareResultBean.setLengthEquality(length);
        } else {
            fileCompareResultBean.setLengthEquality(true);
        }
        if (!ignoreLastModified) {
            long lastModified2;
            long lastModified1 = source.lastModified();
            boolean lastModified = lastModified1 == (lastModified2 = compare.lastModified());
            fileCompareResultBean.setLastModifiedEquality(lastModified);
        } else {
            fileCompareResultBean.setLastModifiedEquality(true);
        }
        if (!ignoreNameEquality) {
            String sourceFilename = FilenameExtensions.getFilenameWithoutExtension((File)source);
            String compareFilename = FilenameExtensions.getFilenameWithoutExtension((File)compare);
            boolean nameEquality = compareFilename.equalsIgnoreCase(sourceFilename);
            fileCompareResultBean.setNameEquality(nameEquality);
        } else {
            fileCompareResultBean.setNameEquality(true);
        }
    }

    public static void compare(IFileContentResultBean fileContentResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        CompareFileExtensions.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        File source = fileContentResultBean.getSourceFile();
        File compare = fileContentResultBean.getFileToCompare();
        if (!ignoreContentEquality) {
            try {
                String sourceChecksum = FileChecksumExtensions.getChecksum((File)source, (String)HashAlgorithm.SHA_512.getAlgorithm());
                String compareChecksum = FileChecksumExtensions.getChecksum((File)compare, (String)HashAlgorithm.SHA_512.getAlgorithm());
                boolean contentEquality = sourceChecksum.equals(compareChecksum);
                fileContentResultBean.setContentEquality(contentEquality);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    boolean contentEquality = FileChecksumExtensions.getCheckSumCRC32((File)source) == FileChecksumExtensions.getCheckSumCRC32((File)compare);
                    fileContentResultBean.setContentEquality(contentEquality);
                }
                catch (IOException e1) {
                    fileContentResultBean.setContentEquality(false);
                }
            }
            catch (IOException e) {
                fileContentResultBean.setContentEquality(false);
            }
        } else {
            fileContentResultBean.setContentEquality(true);
        }
    }

    public static IFileContentResultBean compareFileContentByBytes(File sourceFile, File fileToCompare) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileExtensions.completeCompare(fileContentResultBean);
        boolean simpleEquality = CompareFileExtensions.validateEquality(fileContentResultBean);
        boolean contentEquality = true;
        if (simpleEquality) {
            try (InputStream sourceReader = StreamExtensions.getInputStream((File)sourceFile);
                 InputStream compareReader = StreamExtensions.getInputStream((File)fileToCompare);){
                byte[] source = StreamExtensions.getByteArray((InputStream)sourceReader);
                byte[] compare = StreamExtensions.getByteArray((InputStream)compareReader);
                int i = 0;
                while (0 < source.length) {
                    if (source[i] != compare[i]) {
                        contentEquality = false;
                        break;
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                contentEquality = false;
            }
            catch (IOException e) {
                contentEquality = false;
            }
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    public static IFileContentResultBean compareFileContentByLines(File sourceFile, File fileToCompare) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileExtensions.completeCompare(fileContentResultBean);
        boolean simpleEquality = CompareFileExtensions.validateEquality(fileContentResultBean);
        boolean contentEquality = true;
        if (simpleEquality) {
            try (BufferedReader sourceReader = (BufferedReader)StreamExtensions.getReader((File)sourceFile);
                 BufferedReader compareReader = (BufferedReader)StreamExtensions.getReader((File)fileToCompare);){
                String sourceLine;
                while ((sourceLine = sourceReader.readLine()) != null) {
                    String compareLine = compareReader.readLine();
                    if (compareLine != null && sourceLine.equals(compareLine)) continue;
                    contentEquality = false;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                contentEquality = false;
            }
            catch (IOException e) {
                contentEquality = false;
            }
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, false, false, true, false, true);
    }

    public static boolean compareFiles(File source, File compare, boolean content) {
        boolean equal = true;
        if (!source.exists()) {
            if (!compare.exists()) {
                boolean sameFilename = source.getName().equals(compare.getName());
                return sameFilename;
            }
            return false;
        }
        if (!compare.exists()) {
            return false;
        }
        if (source.length() != compare.length()) {
            return false;
        }
        if (content) {
            try (BufferedReader sourceReader = (BufferedReader)StreamExtensions.getReader((File)source);
                 BufferedReader compareReader = (BufferedReader)StreamExtensions.getReader((File)compare);){
                String sourceLine;
                while ((sourceLine = sourceReader.readLine()) != null) {
                    String compareLine = compareReader.readLine();
                    if (compareLine != null && sourceLine.equals(compareLine)) continue;
                    equal = false;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                equal = false;
            }
            catch (IOException e) {
                equal = false;
            }
        }
        return equal;
    }

    public static IFileCompareResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        FileCompareResultBean fileCompareResultBean = new FileCompareResultBean(sourceFile, fileToCompare);
        CompareFileExtensions.compare(fileCompareResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        return fileCompareResultBean;
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileExtensions.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality);
        return fileContentResultBean;
    }

    public static void completeCompare(IFileCompareResultBean fileCompareResultBean) {
        CompareFileExtensions.compare(fileCompareResultBean, false, false, false, false, false);
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch) {
        List<File> allFiles = FileSearchExtensions.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (File file : allFiles) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(compareResultBean = CompareFileExtensions.simpleCompareFiles(toCompare, file))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allFiles = FileSearchExtensions.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(compareResultBean = CompareFileExtensions.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare) {
        List<File> allSourceFiles = FileSearchExtensions.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchExtensions.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(compareResultBean = CompareFileExtensions.simpleCompareFiles(toCompare, file))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allSourceFiles = FileSearchExtensions.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchExtensions.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(compareResultBean = CompareFileExtensions.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchExtensions.findFilesRecursive(dirToSearch, "*");
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(contentResultBean = CompareFileExtensions.compareFiles(toCompare, file))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchExtensions.findFilesRecursive(dirToSearch, "*");
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(contentResultBean = CompareFileExtensions.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare) {
        List<File> allSourceFiles = FileSearchExtensions.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchExtensions.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(contentResultBean = CompareFileExtensions.compareFiles(toCompare, file))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        List<File> allSourceFiles = FileSearchExtensions.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchExtensions.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileExtensions.validateEquality(contentResultBean = CompareFileExtensions.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static IFileCompareResultBean simpleCompareFiles(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, false, false, true, false);
    }

    public static boolean validateEquality(IFileCompareResultBean fileCompareResultBean) {
        return fileCompareResultBean.getFileExtensionEquality() && fileCompareResultBean.getLengthEquality() && fileCompareResultBean.getLastModifiedEquality() && fileCompareResultBean.getNameEquality();
    }

    public static boolean validateEquality(IFileContentResultBean fileContentResultBean) {
        return fileContentResultBean.getFileExtensionEquality() && fileContentResultBean.getLengthEquality() && fileContentResultBean.getLastModifiedEquality() && fileContentResultBean.getNameEquality() && fileContentResultBean.getContentEquality();
    }
}

