/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create;

import java.io.File;
import java.util.Objects;

public class FileInfo {
    private String name;
    private String path;
    private boolean directory;

    public FileInfo(String name, String path, boolean directory) {
        this.name = name;
        this.path = path;
        this.directory = directory;
    }

    public FileInfo() {
    }

    public FileInfo(File file) {
        Objects.requireNonNull(file);
        this.path = file.getParentFile().getAbsolutePath();
        this.name = file.getName();
        this.directory = file.isDirectory();
    }

    protected FileInfo(FileInfoBuilder<?, ?> b) {
        this.name = b.name;
        this.path = b.path;
        this.directory = b.directory;
    }

    public static File toFile(FileInfo fileInfo) {
        return new File(fileInfo.getPath(), fileInfo.getName());
    }

    public static FileInfo toFileInfo(File file) {
        Objects.requireNonNull(file);
        return ((FileInfoBuilder)((FileInfoBuilder)((FileInfoBuilder)FileInfo.builder().path(file.getParentFile().getAbsolutePath())).name(file.getName())).directory(file.isDirectory())).build();
    }

    public static FileInfoBuilder<?, ?> builder() {
        return new FileInfoBuilderImpl();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        return this.isDirectory() == other.isDirectory();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + (this.isDirectory() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "FileInfo(name=" + this.getName() + ", path=" + this.getPath() + ", directory=" + this.isDirectory() + ")";
    }

    public FileInfoBuilder<?, ?> toBuilder() {
        return new FileInfoBuilderImpl().$fillValuesFrom(this);
    }

    public static abstract class FileInfoBuilder<C extends FileInfo, B extends FileInfoBuilder<C, B>> {
        private String name;
        private String path;
        private boolean directory;

        private static void $fillValuesFromInstanceIntoBuilder(FileInfo instance, FileInfoBuilder<?, ?> b) {
            b.name(instance.name);
            b.path(instance.path);
            b.directory(instance.directory);
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B path(String path) {
            this.path = path;
            return this.self();
        }

        public B directory(boolean directory) {
            this.directory = directory;
            return this.self();
        }

        protected B $fillValuesFrom(C instance) {
            FileInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "FileInfo.FileInfoBuilder(name=" + this.name + ", path=" + this.path + ", directory=" + this.directory + ")";
        }
    }

    private static final class FileInfoBuilderImpl
    extends FileInfoBuilder<FileInfo, FileInfoBuilderImpl> {
        private FileInfoBuilderImpl() {
        }

        @Override
        protected FileInfoBuilderImpl self() {
            return this;
        }

        @Override
        public FileInfo build() {
            return new FileInfo(this);
        }
    }
}

