/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.modify;

import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.file.modify.api.FileChangeable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public final class ModifyFileExtensions {
    private ModifyFileExtensions() {
    }

    public static void modifyFile(Path inFilePath, Charset charsetOfOutputFile, FileChangeable modifier) throws IOException {
        Objects.requireNonNull(inFilePath);
        Objects.requireNonNull(charsetOfOutputFile);
        Objects.requireNonNull(modifier);
        File file = inFilePath.toFile();
        List lines = ListFactory.newArrayList((Object[])new String[0]);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String readLine;
            while ((readLine = bufferedReader.readLine()) != null) {
                lines.add(readLine);
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetOfOutputFile));){
            int counter = 0;
            for (String line : lines) {
                writer.write((String)modifier.apply(counter, line));
                ++counter;
            }
        }
    }

    public static void modifyFile(Path inFilePath, FileChangeable modifier) throws IOException {
        Objects.requireNonNull(inFilePath);
        Objects.requireNonNull(modifier);
        ModifyFileExtensions.modifyFile(inFilePath, StandardCharsets.UTF_8, modifier);
    }

    public static void modifyFile(Path inFilePath, Path outFilePath, Charset charsetOfOutputFile, FileChangeable modifier) throws IOException {
        Objects.requireNonNull(inFilePath);
        Objects.requireNonNull(outFilePath);
        Objects.requireNonNull(charsetOfOutputFile);
        Objects.requireNonNull(modifier);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(inFilePath.toFile()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFilePath.toFile()), charsetOfOutputFile));){
            String readLine;
            int counter = 0;
            while ((readLine = bufferedReader.readLine()) != null) {
                writer.write((String)modifier.apply(counter, readLine));
                ++counter;
            }
        }
    }

    public static void modifyFile(Path inFilePath, Path outFilePath, FileChangeable modifier) throws IOException {
        Objects.requireNonNull(inFilePath);
        Objects.requireNonNull(outFilePath);
        Objects.requireNonNull(modifier);
        ModifyFileExtensions.modifyFile(inFilePath, outFilePath, StandardCharsets.UTF_8, modifier);
    }
}

