/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file;

import io.github.astrapi69.file.read.ReadFileExtensions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileLock;
import java.nio.file.Files;

public final class FileExtensions {
    private FileExtensions() {
    }

    public static byte[] download(URI uri) throws IOException {
        File tmpFile = new File(uri);
        return ReadFileExtensions.toByteArray(tmpFile);
    }

    public static String getAbsolutPathWithoutFilename(File file) {
        String absolutePath = file.getAbsolutePath();
        int lastSlash_index = absolutePath.lastIndexOf("/");
        if (lastSlash_index < 0) {
            lastSlash_index = absolutePath.lastIndexOf("\\");
        }
        return absolutePath.substring(0, lastSlash_index + 1);
    }

    public static String getCurrentAbsolutPathWithoutDotAndSlash() {
        File currentAbsolutPath = new File(".");
        return currentAbsolutPath.getAbsolutePath().substring(0, currentAbsolutPath.getAbsolutePath().length() - 2);
    }

    public static String getContentType(File file) throws IOException {
        return Files.probeContentType(file.toPath());
    }

    public static boolean isOpen(File file) throws IOException {
        boolean open = false;
        try (RandomAccessFile fileAccess = new RandomAccessFile(file.getAbsolutePath(), "rw");){
            FileLock lock = fileAccess.getChannel().tryLock();
            if (lock == null) {
                open = true;
            } else {
                lock.release();
            }
        }
        return open;
    }
}

