/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.merge;

import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class MergeDirectoryExtensions {
    public static void merge(File targetDir, File ... directoriesToMerge) throws IOException {
        MergeDirectoryExtensions.newFileMergeStore(directoriesToMerge).entrySet().forEach(fileEntry -> {
            String relativeName = (String)fileEntry.getKey();
            File srcFile = (File)fileEntry.getValue();
            RuntimeExceptionDecorator.decorate(() -> FileUtils.copyFile((File)srcFile, (File)new File(targetDir, relativeName)));
        });
    }

    private static Map<String, File> newFileMergeStore(File ... directoriesToMerge) {
        HashMap<String, File> fileMergeStore = new HashMap<String, File>();
        for (File directoryToMerge : directoriesToMerge) {
            MergeDirectoryExtensions.refreshFileStore(directoryToMerge, fileMergeStore, null);
        }
        return fileMergeStore;
    }

    private static void refreshFileStore(File baseDirectory, Map<String, File> fileStore, String relativeName) {
        File[] files;
        for (File file : files = Objects.requireNonNull(baseDirectory.listFiles())) {
            String relativeFileName = MergeDirectoryExtensions.getRelativeFileName(relativeName, file.getName());
            if (file.isFile()) {
                File existingFile = fileStore.get(relativeFileName);
                if (existingFile != null && file.lastModified() <= existingFile.lastModified()) continue;
                fileStore.put(relativeFileName, file);
                continue;
            }
            MergeDirectoryExtensions.refreshFileStore(file, fileStore, relativeFileName);
        }
    }

    private static String getRelativeFileName(String baseName, String fileName) {
        return baseName == null ? fileName : baseName + "/" + fileName;
    }
}

