/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.read;

import io.github.astrapi69.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class ReadFileExtensions {
    private ReadFileExtensions() {
    }

    public static Byte[] getFilecontentAsByteObjectArray(File tmpFile) throws IOException {
        return ReadFileExtensions.toObject(ReadFileExtensions.toByteArray(tmpFile));
    }

    public static byte[] readFileToBytearray(File file) throws IOException {
        return ReadFileExtensions.toByteArray(file);
    }

    public static String fromFile(File file) throws IOException {
        return ReadFileExtensions.fromFile(file, StandardCharsets.UTF_8);
    }

    public static String fromFile(File file, Charset encoding) throws IOException {
        try (InputStream inputStream = StreamExtensions.getInputStream((File)file);){
            String string;
            try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);){
                int tmp;
                StringBuilder stringBuilder = new StringBuilder();
                char[] charArray = new char[8192];
                while ((tmp = reader.read(charArray)) > 0) {
                    stringBuilder.append(charArray, 0, tmp);
                }
                string = stringBuilder.toString();
            }
            return string;
        }
    }

    public static String readHeadLine(String inputFile) throws FileNotFoundException, IOException {
        String headLine;
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
            headLine = reader.readLine();
        }
        return headLine;
    }

    public static List<String> readLinesInList(File input) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static String readLine(File input, int index) throws FileNotFoundException, IOException {
        List<String> linesRead = ReadFileExtensions.readLinesInList(input, false);
        if (index < linesRead.size()) {
            return linesRead.get(index);
        }
        return null;
    }

    public static List<String> readLinesInList(File input, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), trim);
    }

    public static List<String> readLinesInList(File input, Charset encoding) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(input, encoding, false);
    }

    public static List<String> readLinesInList(File input, Charset encoding, boolean trim) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readLinesInList(new FileInputStream(input), encoding, trim);
    }

    public static List<String> readLinesInList(InputStream input) throws IOException {
        return ReadFileExtensions.readLinesInList(input, false);
    }

    public static List<String> readLinesInList(InputStream input, boolean trim) throws IOException {
        return ReadFileExtensions.readLinesInList(input, StandardCharsets.UTF_8, trim);
    }

    public static List<String> readLinesInList(InputStream input, Charset encoding, boolean trim) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (InputStreamReader isr = encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding);
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (trim) {
                    line.trim();
                }
                output.add(line);
            }
        }
        return output;
    }

    public static Properties readPropertiesFromFile(String filename) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(filename);){
            properties.load(fis);
        }
        return properties;
    }

    public static byte[] toByteArray(File tmpFile) throws IOException {
        byte[] data = null;
        if (tmpFile.exists() && !tmpFile.isDirectory()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(tmpFile));
                 ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
                StreamExtensions.writeInputStreamToOutputStream((InputStream)bis, (OutputStream)bos);
                data = bos.toByteArray();
            }
        }
        return data;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    private static Byte[] toObject(byte[] byteArray) {
        return ArrayUtils.toObject((byte[])byteArray);
    }

    public static long countAllLines(File fileToCountTheLines) throws IOException {
        return Files.lines(fileToCountTheLines.toPath()).count();
    }
}

