/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.write;

import io.github.astrapi69.file.create.FileFactory;
import io.github.astrapi69.file.system.SystemPropertiesExtensions;
import io.github.astrapi69.file.write.StoreFileExtensions;
import io.github.astrapi69.io.StreamExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public final class WriteFileExtensions {
    private WriteFileExtensions() {
    }

    public static void readSourceFileAndWriteDestFile(String srcfile, String destFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(srcfile);
             FileOutputStream fos = new FileOutputStream(destFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int availableLength = bis.available();
            byte[] totalBytes = new byte[availableLength];
            bis.read(totalBytes, 0, availableLength);
            bos.write(totalBytes, 0, availableLength);
        }
    }

    public static void string2File(String string2write, String nameOfFile) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(nameOfFile));){
            bufferedWriter.write(string2write);
            bufferedWriter.flush();
        }
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws FileNotFoundException, IOException {
        StreamExtensions.writeInputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void write2File(Reader reader, Writer writer) throws IOException {
        StreamExtensions.writeReaderToWriter((Reader)reader, (Writer)writer);
    }

    public static void write2File(String inputFile, String outputFile) throws IOException {
        try (InputStream is = StreamExtensions.getInputStream((String)inputFile);
             OutputStream os = StreamExtensions.getOutputStream((String)outputFile);){
            WriteFileExtensions.write(is, os);
        }
    }

    public static void write2File(String inputFile, Writer writer) throws FileNotFoundException, IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(inputFile));){
            WriteFileExtensions.write2File(bufferedReader, writer);
        }
    }

    public static void write2FileWithBuffer(String inputFile, String outputFile) throws FileNotFoundException, IOException {
        try (InputStream inputStream = StreamExtensions.getInputStream((File)new File(inputFile));
             OutputStream outputStream = StreamExtensions.getOutputStream((File)new File(outputFile));){
            WriteFileExtensions.write(inputStream, outputStream);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byteArray) throws IOException {
        Files.write(file.toPath(), byteArray, new OpenOption[0]);
    }

    public static void writeByteArrayToFile(String filename, byte[] byteArray) throws IOException {
        WriteFileExtensions.writeByteArrayToFile(FileFactory.newFile(filename), byteArray);
    }

    public static void writeLinesToFile(Collection<String> lines, File output) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append("\n");
        }
        StoreFileExtensions.toFile(output, sb.toString());
    }

    public static void writeLinesToFile(Collection<String> lines, File output, String encoding) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = SystemPropertiesExtensions.getLineSeparator();
        for (String line : lines) {
            sb.append(line);
            sb.append(lineSeparator);
        }
        StoreFileExtensions.toFile(output, sb.toString(), encoding);
    }

    public static void writeLinesToFile(File output, List<String> input, String encoding) throws FileNotFoundException, IOException {
        String lineSeparator = SystemPropertiesExtensions.getLineSeparator();
        try (FileOutputStream fos = new FileOutputStream(output);
             OutputStreamWriter osw = null == encoding ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, encoding);
             PrintWriter out = new PrintWriter(osw);){
            int size = input.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                String entry = input.get(i);
                sb.append(entry).append(lineSeparator);
            }
            out.write(sb.toString());
        }
    }

    public static void writeProperties2File(String filename, Properties properties) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            properties.store(fos, null);
        }
    }
}

