/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.zip;

import io.github.astrapi69.collection.set.SetFactory;
import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.create.FileFactory;
import io.github.astrapi69.file.exception.FileDoesNotExistException;
import io.github.astrapi69.file.search.FileSearchExtensions;
import io.github.astrapi69.io.file.FileConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipExtensions {
    private ZipExtensions() {
    }

    private static void addFile(File file, File dirToZip, ZipOutputStream zos) throws IOException {
        String zipEntryName = ZipExtensions.getZipEntryName(file, dirToZip);
        byte[] b = new byte[(int)file.length()];
        ZipEntry cpZipEntry = new ZipEntry(zipEntryName);
        zos.putNextEntry(cpZipEntry);
        zos.write(b, 0, (int)file.length());
        zos.closeEntry();
    }

    public static void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        File fileToExtract = new File(toDirectory, target.getName());
        DirectoryFactory.mkParentDirs(fileToExtract);
        try (InputStream is = zipFile.getInputStream(target);
             BufferedInputStream bis = new BufferedInputStream(is);
             FileOutputStream fos = new FileOutputStream(fileToExtract);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int c;
            while ((c = bis.read()) != -1) {
                bos.write((byte)c);
            }
            bos.flush();
        }
    }

    static List<File> getFoundedFiles(File file, File[] tmpfList) {
        List<File> foundedFiles;
        List<File> foundedDirs = FileSearchExtensions.listDirs(file);
        if (0 < foundedDirs.size()) {
            foundedDirs.addAll(Arrays.asList(tmpfList));
            foundedFiles = foundedDirs;
        } else {
            foundedFiles = Arrays.asList(tmpfList);
        }
        return foundedFiles;
    }

    private static String getZipEntryName(File file, File dirToZip) {
        String absolutePath = file.getAbsolutePath();
        String name = dirToZip.getName();
        int index = absolutePath.indexOf(name);
        return absolutePath.substring(index);
    }

    public static boolean isZip(String filename) {
        for (String element : FileConstants.ZIP_EXTENSIONS) {
            if (!filename.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipFile zipFile, File toDir) throws IOException {
        try {
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipExtensions.extractZipEntry(zipFile, entry, toDir);
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void zip(File fileToZip, File zipFile) throws FileNotFoundException, IOException, FileDoesNotExistException {
        ZipExtensions.zip(fileToZip, zipFile, null);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter) throws FileNotFoundException, IOException, FileDoesNotExistException {
        ZipExtensions.zip(dirToZip, zipFile, filter, true);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter, boolean createFile) throws FileNotFoundException, IOException, FileDoesNotExistException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipExtensions.newZipFile(dirToZip, zipFile, createFile);
            zos.setLevel(9);
            ZipExtensions.zipFiles(dirToZip, dirToZip, zos, filter);
            zos.flush();
            zos.finish();
            fos.flush();
        }
    }

    private static void newZipFile(File dirToZip, File zipFile, boolean createFile) throws IOException, FileDoesNotExistException {
        if (!dirToZip.exists()) {
            throw new IOException("Directory with the name " + dirToZip.getName() + " does not exist.");
        }
        if (!zipFile.exists()) {
            if (createFile) {
                FileFactory.newFile(zipFile);
            } else {
                throw new FileDoesNotExistException("Zipfile with the name " + zipFile.getName() + " does not exist.");
            }
        }
    }

    private static void zipFiles(File file, File dirToZip, ZipOutputStream zos, FilenameFilter fileFilter) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            List<File> foundedFiles = null != fileFilter ? ZipExtensions.getFoundedFiles(file, file.listFiles(fileFilter)) : ((files = file.listFiles()) != null ? Arrays.asList(files) : new ArrayList<File>());
            for (int i = 0; i < foundedFiles.size(); ++i) {
                ZipExtensions.zipFiles(foundedFiles.get(i), dirToZip, zos, fileFilter);
            }
        } else {
            ZipExtensions.addFile(file, dirToZip, zos);
        }
    }

    public static void zipFiles(File file, File dirToZip, FileFilter ... excludeFileFilter) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(dirToZip);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            Set<File> fileSet = FileSearchExtensions.findFiles(file, SetFactory.newHashSet((Object[])new File[0]), excludeFileFilter);
            for (File foundedFile : fileSet) {
                byte[] b = new byte[(int)foundedFile.length()];
                ZipEntry cpZipEntry = new ZipEntry(foundedFile.getAbsolutePath());
                zos.putNextEntry(cpZipEntry);
                zos.write(b, 0, (int)foundedFile.length());
            }
        }
    }
}

