/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.search;

import io.github.astrapi69.io.file.filter.MultiplyExtensionsFileFilter;
import io.github.astrapi69.regex.RegExExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FileSearchExtensions {
    private FileSearchExtensions() {
    }

    public static File getRootDirectory(File file) {
        File previous = file;
        for (File parent = previous.getParentFile(); parent != null; parent = parent.getParentFile()) {
            previous = parent;
        }
        return previous;
    }

    public static boolean containsFile(File parent, File search) {
        String[] children = parent.list();
        if (children == null) {
            return false;
        }
        boolean exists = false;
        List<String> fileList = Arrays.asList(children);
        if (fileList.contains(search.getName())) {
            exists = true;
        }
        return exists;
    }

    public static boolean containsFile(File fileToSearch, String pathname) {
        String[] allFiles = fileToSearch.list();
        if (allFiles == null) {
            return false;
        }
        List<String> list = Arrays.asList(allFiles);
        return list.contains(pathname);
    }

    public static boolean containsFileRecursive(File parent, File search) {
        File toSearch = search.getAbsoluteFile();
        boolean exists = false;
        File[] children = parent.getAbsoluteFile().listFiles();
        if (children == null) {
            return false;
        }
        List<File> fileList = Arrays.asList(children);
        for (File currentFile : fileList) {
            if (currentFile.isDirectory() && (exists = FileSearchExtensions.containsFileRecursive(currentFile, toSearch))) {
                return true;
            }
            if (!fileList.contains(toSearch)) continue;
            return true;
        }
        return exists;
    }

    public static Set<File> findFiles(File directory, Set<File> foundedDirs, FileFilter ... excludeFileFilters) {
        File[] children;
        if (foundedDirs == null) {
            foundedDirs = new HashSet<File>();
        }
        if ((children = directory.getAbsoluteFile().listFiles()) == null || children.length < 1) {
            return foundedDirs;
        }
        HashSet<File> excludeFileList = new HashSet<File>();
        for (FileFilter fileFilter : excludeFileFilters) {
            File[] excudeFiles = directory.listFiles(fileFilter);
            if (excudeFiles == null) continue;
            excludeFileList.addAll(Arrays.asList(excudeFiles));
        }
        for (File element : children) {
            if (element.isDirectory()) {
                FileSearchExtensions.findFiles(element, foundedDirs, excludeFileFilters);
                continue;
            }
            if (excludeFileList.contains(element)) continue;
            foundedDirs.add(element);
        }
        return foundedDirs;
    }

    public static Set<File> findFiles(File directory, Predicate<File> predicate) throws IOException {
        try (Stream<Path> pathStream = Files.list(Paths.get(directory.getAbsolutePath(), new String[0]));){
            Set<File> set = pathStream.map(Path::toFile).filter(predicate).collect(Collectors.toSet());
            return set;
        }
    }

    public static Set<File> findFilesRecursive(File directory, Predicate<File> predicate) throws IOException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            Set<File> set = pathStream.map(Path::toFile).filter(predicate).collect(Collectors.toSet());
            return set;
        }
    }

    public static long countAllFilesInDirectory(File dir, long length, boolean includeDirectories) {
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return length;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                if (includeDirectories) {
                    ++length;
                }
                length = FileSearchExtensions.countAllFilesInDirectory(child, length, includeDirectories);
                continue;
            }
            ++length;
        }
        return length;
    }

    public static List<File> findAllFiles(File dir, String fileSearchPattern) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundFiles;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                List<File> foundedFiles = FileSearchExtensions.findAllFiles(child, fileSearchPattern);
                foundFiles.addAll(foundedFiles);
                continue;
            }
            String filename = child.getName();
            if (!filename.matches(fileSearchPattern)) continue;
            foundFiles.add(child.getAbsoluteFile());
        }
        return foundFiles;
    }

    public static List<File> findFiles(File dir, String filenameToSearch) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = RegExExtensions.replaceWildcardsWithRE((String)filenameToSearch);
        String[] children = dir.list();
        if (children != null) {
            for (String filename : children) {
                if (!filename.matches(regex)) continue;
                File foundedFile = new File(filename);
                foundedFileList.add(foundedFile);
            }
        }
        return foundedFileList;
    }

    public static List<File> findFiles(String start, String[] extensions) {
        ArrayList<File> files = new ArrayList<File>();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(start);
        if (startdir.isDirectory()) {
            dirs.push(new File(start));
        }
        while (!dirs.isEmpty()) {
            File dirFiles = (File)dirs.pop();
            String[] s = dirFiles.list();
            if (s == null) continue;
            for (String element : s) {
                File file = new File(dirFiles.getAbsolutePath() + File.separator + element);
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                if (!FileSearchExtensions.match(element, extensions)) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static List<File> findFilesRecursive(File dir, String filenameToSearch) {
        return FileSearchExtensions.findFilesRecursive(dir, false, filenameToSearch);
    }

    public static List<File> findFilesRecursive(File dir, boolean includeDir, String filenameToSearch) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = RegExExtensions.replaceWildcardsWithRE((String)filenameToSearch);
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File element : children) {
            if (element.isDirectory()) {
                if (includeDir) {
                    foundedFileList.add(element);
                }
                List<File> foundedFiles = FileSearchExtensions.findFilesRecursive(element, includeDir, filenameToSearch);
                foundedFileList.addAll(foundedFiles);
                continue;
            }
            String filename = element.getName();
            if (!filename.matches(regex)) continue;
            foundedFileList.add(element.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> findFilesWithFilter(File dir, String ... extension) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        File[] children = dir.listFiles((FileFilter)new MultiplyExtensionsFileFilter(true, extension));
        if (children != null) {
            for (File element : children) {
                if (element.isDirectory()) {
                    foundedFileList.addAll(FileSearchExtensions.findFilesWithFilter(element, extension));
                    continue;
                }
                foundedFileList.add(element.getAbsoluteFile());
            }
        }
        return foundedFileList;
    }

    public static int findLineIndex(File file, String searchString) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            int index = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(searchString)) {
                    int n = index;
                    return n;
                }
                ++index;
            }
        }
        return -1;
    }

    public static List<File> getAllFilesFromDir(File dir) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File child : children) {
            if (child.isDirectory()) continue;
            foundedFileList.add(child.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> getAllFilesFromDirRecursive(File dir) {
        return FileSearchExtensions.findFilesRecursive(dir, "*");
    }

    public static List<File> getAllFilesFromDirRecursive(File dir, boolean includeDir) {
        return FileSearchExtensions.findFilesRecursive(dir, includeDir, "*");
    }

    public static long getFileLengthInKilobytes(File dir) {
        long fileLength = dir.getTotalSpace();
        return fileLength / 1024L;
    }

    public static long getFileLengthInMegabytes(File dir) {
        return FileSearchExtensions.getFileLengthInKilobytes(dir) / 1024L;
    }

    public static String getSearchFilePattern(String ... fileExtensions) {
        if (fileExtensions.length == 0) {
            return "";
        }
        String searchFilePatternPrefix = "([^\\s]+(\\.(?i)(";
        String searchFilePatternSuffix = "))$)";
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (String fileExtension : fileExtensions) {
            if (count < fileExtensions.length) {
                sb.append(fileExtension).append("|");
            } else {
                sb.append(fileExtension);
            }
            ++count;
        }
        return "([^\\s]+(\\.(?i)(" + sb.toString().trim() + "))$)";
    }

    public static List<File> listDirs(File dir) {
        ArrayList<File> foundedDirs = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            for (File element : fileArray) {
                if (!element.isDirectory()) continue;
                foundedDirs.add(element);
            }
        }
        return foundedDirs;
    }

    public static boolean match(String stringToMatch, String[] suffixes) {
        for (String suffix : suffixes) {
            int suffixesLength = suffix.length();
            int stringToMatchLength = stringToMatch.length();
            int result = stringToMatchLength - suffixesLength;
            String extensionToMatch = stringToMatch.substring(result, stringToMatchLength);
            boolean equals = extensionToMatch.equalsIgnoreCase(suffix);
            if (stringToMatchLength < suffixesLength || !equals) continue;
            return true;
        }
        return false;
    }

    public static List<File> findFilesWithPrefixAndExtension(File dir, String prefix, String extension) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = "^" + prefix + ".*\\." + extension + "$";
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File child : children) {
            String filename;
            if (child.isDirectory() || !(filename = child.getName()).matches(regex)) continue;
            foundedFileList.add(child.getAbsoluteFile());
        }
        return foundedFileList;
    }

    public static List<File> findFilesWithPrefixAndExtensionRecursive(File dir, String prefix, String extension) {
        ArrayList<File> foundedFileList = new ArrayList<File>();
        String regex = "^" + prefix + ".*\\." + extension + "$";
        File[] children = dir.getAbsoluteFile().listFiles();
        if (children == null || children.length < 1) {
            return foundedFileList;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                foundedFileList.addAll(FileSearchExtensions.findFilesWithPrefixAndExtensionRecursive(child, prefix, extension));
                continue;
            }
            String filename = child.getName();
            if (!filename.matches(regex)) continue;
            foundedFileList.add(child.getAbsoluteFile());
        }
        return foundedFileList;
    }
}

