/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.system;

import io.github.astrapi69.file.system.SystemPropertiesExtensions;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;

public final class SystemFileExtensions {
    public static final String DEFAULT_USER_CONFIGURATION_DIRECTORY_NAME = ".config";
    public static final String DEFAULT_USER_DOWNLOAD_DIRECTORY_NAME = "Downloads";
    public static final String DEFAULT_USER_TEMPORARY_DIRECTORY_NAME = "tmp";

    private SystemFileExtensions() {
    }

    public static File getJavaHomeDir() {
        return new File(SystemPropertiesExtensions.getJavaHome());
    }

    public static File getTempDir() {
        return new File(SystemPropertiesExtensions.getJavaIoTmpdir());
    }

    public static File getUserHomeDir() {
        return new File(SystemPropertiesExtensions.getUserHome());
    }

    public static File getUserDownloadsDir() {
        return SystemFileExtensions.getUserDownloadsDir("");
    }

    public static File getUserDownloadsDir(String downloadsDirname) {
        String ddn = downloadsDirname;
        if (downloadsDirname == null || downloadsDirname.isEmpty()) {
            ddn = DEFAULT_USER_DOWNLOAD_DIRECTORY_NAME;
        }
        String userHomePath = SystemPropertiesExtensions.getUserHome();
        return new File(userHomePath + File.separator + ddn);
    }

    public static File getUserTempDir() {
        return SystemFileExtensions.getUserTempDir("");
    }

    public static File getUserTempDir(String tempDirname) {
        String tdn = tempDirname;
        if (tempDirname == null || tempDirname.isEmpty()) {
            tdn = DEFAULT_USER_TEMPORARY_DIRECTORY_NAME;
        }
        String userHomePath = SystemPropertiesExtensions.getUserHome();
        return new File(userHomePath + File.separator + tdn);
    }

    public static File getUserConfigurationDir(String configurationDirname) {
        String ddn = configurationDirname;
        if (configurationDirname == null || configurationDirname.isEmpty()) {
            ddn = DEFAULT_USER_CONFIGURATION_DIRECTORY_NAME;
        }
        String userHomePath = SystemPropertiesExtensions.getUserHome();
        return new File(userHomePath + File.separator + ddn);
    }

    public static File getUserConfigurationDir() {
        return SystemFileExtensions.getUserConfigurationDir("");
    }

    public static File getUserWorkingDir() {
        String userWorkingPath = SystemPropertiesExtensions.getUserWorkingDirectory();
        return new File(userWorkingPath);
    }

    public static File getRootDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            String systemDrive = System.getenv("SystemDrive");
            return new File(systemDrive);
        }
        return new File("/");
    }

    public static Optional<File> getWindowsRootDriveDir(char driveLetter) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String driveName = driveLetter + ":";
            return Optional.of(new File(driveName));
        }
        return Optional.empty();
    }
}

