/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create;

import io.github.astrapi69.file.create.FileCreationState;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public final class DirectoryFactory {
    private DirectoryFactory() {
    }

    public static Collection<FileCreationState> newDirectories(Collection<File> directories) {
        ArrayList<FileCreationState> fileCreationStates = new ArrayList<FileCreationState>();
        for (File dir : directories) {
            FileCreationState created = FileCreationState.PENDING;
            created = DirectoryFactory.newDirectory(dir);
            fileCreationStates.add(created);
        }
        return fileCreationStates;
    }

    public static boolean newDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path directory = Files.createDirectories(dir, attrs);
        return Files.exists(directory, new LinkOption[0]);
    }

    public static boolean newDirectoriesQuietly(Path dir, FileAttribute<?> ... attrs) {
        return (Boolean)RuntimeExceptionDecorator.decorate(() -> DirectoryFactory.newDirectories(dir, attrs));
    }

    public static boolean newDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path directory = Files.createDirectory(dir, attrs);
        return Files.exists(directory, new LinkOption[0]);
    }

    public static boolean newDirectoryQuietly(Path dir, FileAttribute<?> ... attrs) {
        return (Boolean)RuntimeExceptionDecorator.decorate(() -> DirectoryFactory.newDirectory(dir, attrs));
    }

    public static File newDirectory(String absolutePath) throws IOException {
        Path dir = Paths.get(absolutePath, new String[0]);
        File directory = dir.toFile();
        if (!directory.exists()) {
            DirectoryFactory.newDirectory(dir, new FileAttribute[0]);
        }
        return directory;
    }

    public static File newDirectoryQuietly(String absolutePath) {
        Path dir = Paths.get(absolutePath, new String[0]);
        File directory = dir.toFile();
        if (!directory.exists()) {
            DirectoryFactory.newDirectoryQuietly(dir, new FileAttribute[0]);
        }
        return directory;
    }

    public static FileCreationState newDirectory(File directory) {
        FileCreationState fileCreationState = FileCreationState.ALREADY_EXISTS;
        if (!directory.exists()) {
            fileCreationState = FileCreationState.FAILED;
            if (directory.mkdir()) {
                fileCreationState = FileCreationState.CREATED;
            }
        }
        fileCreationState.setFile(directory);
        return fileCreationState;
    }

    public static File newDirectory(File parentDirectory, String directoryName) {
        Objects.requireNonNull(parentDirectory);
        Objects.requireNonNull(directoryName);
        if (!parentDirectory.exists()) {
            throw new RuntimeException("Given parent directory does not exist");
        }
        if (!parentDirectory.isDirectory()) {
            throw new RuntimeException("Given parent file is not a directory");
        }
        File directory = new File(parentDirectory, directoryName);
        DirectoryFactory.newDirectory(directory);
        return directory;
    }

    public static File newDirectory(String parentDirectory, String directoryName) throws IOException {
        Path dir = Paths.get(parentDirectory, directoryName);
        File directory = dir.toFile();
        if (!directory.exists()) {
            DirectoryFactory.newDirectory(dir, new FileAttribute[0]);
        }
        return directory;
    }

    public static File newDirectoryQuietly(String parentDirectory, String directoryName) {
        Path dir = Paths.get(parentDirectory, directoryName);
        File directory = dir.toFile();
        if (!directory.exists()) {
            DirectoryFactory.newDirectoryQuietly(dir, new FileAttribute[0]);
        }
        return directory;
    }

    public static boolean mkParentDirs(File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            return parent.mkdirs();
        }
        return true;
    }

    public static File newTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(prefix, attrs).toFile();
    }

    public static File newTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(dir, prefix, attrs).toFile();
    }

    public static FileCreationState newTempDir(String prefix, FileAttribute<?> ... attrs) throws IOException {
        File tempDirectory = DirectoryFactory.newTempDirectory(prefix, attrs);
        return DirectoryFactory.newDirectory(tempDirectory);
    }

    public static FileCreationState newTempDir(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        File tempDirectory = DirectoryFactory.newTempDirectory(dir, prefix, attrs);
        return DirectoryFactory.newDirectory(tempDirectory);
    }
}

