/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create;

import io.github.astrapi69.checksum.FileChecksumExtensions;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.ChecksumAlgorithm;
import io.github.astrapi69.file.FileExtensions;
import io.github.astrapi69.file.create.FileFactory;
import io.github.astrapi69.file.create.FileInfo;
import io.github.astrapi69.file.read.ReadFileExtensions;
import io.github.astrapi69.file.write.StoreFileExtensions;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.util.Arrays;

public class FileContentInfo
extends FileInfo {
    private String checksum;
    private byte[] content;

    public FileContentInfo(String checksum, byte[] content) {
        this.checksum = checksum;
        this.content = content;
    }

    public FileContentInfo() {
    }

    protected FileContentInfo(FileContentInfoBuilder<?, ?> b) {
        super(b);
        this.checksum = b.checksum;
        this.content = b.content;
    }

    public static FileContentInfo toFileContentInfo(File file) {
        if (file.exists() && file.isFile()) {
            return ((FileContentInfoBuilder)((FileContentInfoBuilder)((FileContentInfoBuilder)((FileContentInfoBuilder)FileContentInfo.builder().name(file.getName())).path(FileExtensions.getAbsolutPathWithoutFilename(file))).checksum((String)RuntimeExceptionDecorator.decorate(() -> FileChecksumExtensions.getChecksum((File)file, (Algorithm)ChecksumAlgorithm.MD5)))).content((byte[])RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFileToBytearray(file)))).build();
        }
        return ((FileContentInfoBuilder)((FileContentInfoBuilder)((FileContentInfoBuilder)FileContentInfo.builder().name(file.getName())).directory(true)).path(FileExtensions.getAbsolutPathWithoutFilename(file))).build();
    }

    public static File toFile(FileContentInfo fileContentInfo) {
        File file = new File(fileContentInfo.getPath(), fileContentInfo.getName());
        if (!fileContentInfo.isDirectory()) {
            if (!file.exists()) {
                RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(file));
            }
            RuntimeExceptionDecorator.decorate(() -> StoreFileExtensions.toFile(file, fileContentInfo.getContent()));
        }
        return file;
    }

    public static FileContentInfoBuilder<?, ?> builder() {
        return new FileContentInfoBuilderImpl();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileContentInfo)) {
            return false;
        }
        FileContentInfo other = (FileContentInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$checksum = this.getChecksum();
        String other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        return Arrays.equals(this.getContent(), other.getContent());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileContentInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        return result;
    }

    @Override
    public String toString() {
        return "FileContentInfo{checksum='" + this.getChecksum() + "', content=" + Arrays.toString(this.getContent()) + "}";
    }

    public static abstract class FileContentInfoBuilder<C extends FileContentInfo, B extends FileContentInfoBuilder<C, B>>
    extends FileInfo.FileInfoBuilder<C, B> {
        private String checksum;
        private byte[] content;

        public B checksum(String checksum) {
            this.checksum = checksum;
            return (B)this.self();
        }

        public B content(byte[] content) {
            this.content = content;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FileContentInfo.FileContentInfoBuilder(super=" + super.toString() + ", checksum='" + this.checksum + "', content=" + Arrays.toString(this.content) + ")";
        }
    }

    private static final class FileContentInfoBuilderImpl
    extends FileContentInfoBuilder<FileContentInfo, FileContentInfoBuilderImpl> {
        private FileContentInfoBuilderImpl() {
        }

        @Override
        protected FileContentInfoBuilderImpl self() {
            return this;
        }

        @Override
        public FileContentInfo build() {
            return new FileContentInfo(this);
        }
    }
}

