/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.csv;

import io.github.astrapi69.file.write.StoreFileExtensions;
import io.github.astrapi69.io.StreamExtensions;
import io.github.astrapi69.string.StringExtensions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

@Deprecated
public final class CsvFileExtensions {
    private CsvFileExtensions() {
    }

    public static List<String> formatKommaSeperatedFileToList(File input, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);){
            String line = null;
            block5: while ((line = reader.readLine()) != null) {
                String[] splittedData;
                String[] stringArray = splittedData = line.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block5;
                    String element = stringArray[n2];
                    output.add(element.trim());
                    ++n2;
                }
                break;
            }
        }
        return output;
    }

    private static String formatListToString(List<String> list) {
        int lineLength = 0;
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            int length = str.length();
            lineLength = length + lineLength;
            sb.append(str);
            sb.append(", ");
            if (100 >= lineLength) continue;
            sb.append("\n");
            lineLength = 0;
        }
        return sb.toString().trim();
    }

    public static void formatToCSV(File input, File output, String encoding) throws IOException {
        List<String> list = CsvFileExtensions.readLinesInList(input, "UTF-8");
        String sb = CsvFileExtensions.formatListToString(list);
        StoreFileExtensions.toFile(output, sb, encoding);
    }

    public static List<Map<String, String>> getCvsAsListMap(File input) throws IOException {
        return CsvFileExtensions.getCvsAsListMap(input, "ISO-8859-1");
    }

    public static List<Map<String, String>> getCvsAsListMap(File input, String encoding) throws IOException {
        List<String[]> lines = CsvFileExtensions.readFileToList(input, ";", encoding);
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        String[] headline = lines.remove(0);
        for (String[] line : lines) {
            LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
            String[] currentLine = line;
            for (int j = 0; j < currentLine.length; ++j) {
                context.put(headline[j], currentLine[j]);
            }
            data.add(context);
        }
        return data;
    }

    public static String[] getDataFromLine(String line, String seperator) {
        return CsvFileExtensions.getDataFromLine(line, seperator, false);
    }

    public static String[] getDataFromLine(String line, String seperator, boolean trim) {
        StringTokenizer tokenizer = new StringTokenizer(line, seperator);
        ArrayList<String> data = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String string = tokenizer.nextToken();
            if (trim) {
                data.add(string.trim());
                continue;
            }
            data.add(string);
        }
        String[] splittedLine = data.toArray(new String[0]);
        return splittedLine;
    }

    public static int getLineCountFromCsvFile(File file) throws IOException {
        return CsvFileExtensions.readFileToList(file).size();
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String encoding) throws IOException {
        return CsvFileExtensions.readDataFromCVSFileToList(input, position, putFirstLine, ",", encoding);
    }

    public static List<String> readDataFromCVSFileToList(File input, int position, boolean putFirstLine, String splitChar, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedData = line.split(splitChar);
                if (position > splittedData.length - 1) continue;
                String s = StringExtensions.removeFirstAndLastCharacter((String)splittedData[position]);
                output.add(s);
            }
        }
        if (!putFirstLine) {
            output.remove(0);
        }
        return output;
    }

    public static Properties readFilelistToProperties(File input) throws IOException {
        List<String> list = CsvFileExtensions.readLinesInList(input, null);
        Properties prop = new Properties();
        for (int i = 0; i < list.size(); ++i) {
            String element = list.get(i);
            prop.put("" + i, element);
        }
        return prop;
    }

    public static List<String> readFileToList(File file) throws IOException {
        return CsvFileExtensions.readFileToList(file, null);
    }

    public static List<String> readFileToList(File file, String encoding) throws IOException {
        ArrayList<String> fn = new ArrayList<String>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)file, (String)encoding, (boolean)false);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                fn.add(line);
            }
        }
        return fn;
    }

    public static List<String[]> readFileToList(File file, String seperator, String encoding) throws IOException {
        ArrayList<String[]> fn = new ArrayList<String[]>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)file, (String)encoding, (boolean)false);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] splittedLine = CsvFileExtensions.getDataFromLine(line, seperator);
                fn.add(splittedLine);
            }
        }
        return fn;
    }

    public static List<String> readLinesInList(File input, String encoding) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)input, (String)encoding, (boolean)false);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        return output;
    }

    public static String[] sortData(File csvData, String encoding) throws FileNotFoundException, IOException {
        ArrayList<String> fn = new ArrayList<String>();
        try (BufferedReader reader = (BufferedReader)StreamExtensions.getReader((File)csvData, (String)encoding, (boolean)false);){
            String line = null;
            block7: while ((line = reader.readLine()) != null) {
                int last = 0;
                int index = line.indexOf(44);
                while (true) {
                    if (index == -1) continue block7;
                    String firstname = line.substring(last, index).trim();
                    fn.add(firstname);
                    last = index + 1;
                    index = line.indexOf(44, last);
                }
                break;
            }
        }
        Object[] data = fn.toArray(new String[fn.size()]);
        Arrays.sort(data);
        return data;
    }

    public static void storeFilelistToProperties(File output, File input, String comments) throws IOException {
        Properties prop = CsvFileExtensions.readFilelistToProperties(input);
        try (OutputStream out = StreamExtensions.getOutputStream((File)output, (boolean)true);){
            prop.store(out, comments);
        }
    }

    public static void writeLines(File output, Set<String> values, String encoding) throws IOException {
        CsvFileExtensions.writeLinesToFile(values, output, encoding);
    }

    public static void writeLinesToFile(Collection<String> collection, File output, String encoding) throws IOException {
        StoreFileExtensions.toFile(output, collection, encoding);
    }
}

