/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.csv;

import io.github.astrapi69.file.csv.CsvBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Deprecated
public final class CsvToSqlExtensions {
    private CsvToSqlExtensions() {
    }

    public static String extractSqlColumns(String[] headers) {
        StringBuilder sqlColumns = new StringBuilder();
        for (int i = 0; i < headers.length; ++i) {
            sqlColumns.append(headers[i]);
            if (i >= headers.length - 1) continue;
            sqlColumns.append(", ");
        }
        return sqlColumns.toString();
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, CsvBean csvBean) {
        return CsvToSqlExtensions.getCsvFileAsSqlInsertScript(tableName, csvBean, true, true);
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, CsvBean csvBean, boolean withHeader, boolean withEndSemicolon) {
        String[] columnTypesEdit;
        StringBuilder sb = new StringBuilder();
        if (withHeader) {
            String sqlColumns = CsvToSqlExtensions.extractSqlColumns(csvBean.getHeaders());
            sb.append("INSERT INTO ").append(tableName).append(" ( ").append(sqlColumns).append(") VALUES \n");
        }
        if ((columnTypesEdit = csvBean.getColumnTypesEdit()) != null) {
            StringBuilder sqlData = CsvToSqlExtensions.getSqlData(csvBean.getHeaders(), csvBean.getColumnTypes(), columnTypesEdit, csvBean.getLineOrder(), csvBean.getLines(), withEndSemicolon);
            sb.append((CharSequence)sqlData);
        } else {
            StringBuilder sqlData = CsvToSqlExtensions.getSqlData(csvBean.getHeaders(), csvBean.getColumnTypes(), null, null, csvBean.getLines(), withEndSemicolon);
            sb.append((CharSequence)sqlData);
        }
        return sb.toString();
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, String[] headers, String[] columnTypes, List<String[]> lines) {
        return CsvToSqlExtensions.getCsvFileAsSqlInsertScript(tableName, new CsvBean(headers, columnTypes, lines));
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, String[] headers, String[] columnTypes, String[] columnTypesEdit, List<String[]> lines) {
        return CsvToSqlExtensions.getCsvFileAsSqlInsertScript(tableName, new CsvBean(headers, columnTypes, columnTypesEdit, lines));
    }

    public static String[] getDataFromLine(String line, String seperator) {
        return line.split(seperator);
    }

    public static StringBuilder getSqlData(String[] columns, String[] columnTypes, String[] columnTypesEdit, Map<Integer, Integer> lineOrder, List<String[]> lines, boolean withEndSemicolon) {
        StringBuilder sb = new StringBuilder();
        int autoincrement = 0;
        Iterator<String[]> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String[] line;
            if (lineOrder != null) {
                String[] trueLine = iterator.next();
                String[] newLine = new String[columnTypes.length];
                for (Integer index : lineOrder.keySet()) {
                    newLine[lineOrder.get((Object)index).intValue()] = trueLine[index];
                }
                line = newLine;
            } else {
                line = iterator.next();
            }
            sb.append("(");
            for (int i = 0; i < line.length; ++i) {
                String lineItem = line[i];
                if (columnTypesEdit != null) {
                    String columTypeEdit = columnTypesEdit[i];
                    String[] editTypeData = columTypeEdit.split(",");
                    String editType = editTypeData[0];
                    if (editType.equals("edit")) {
                        if (3 < editTypeData.length) {
                            lineItem = lineItem.replace(editTypeData[1], editTypeData[2]);
                            boolean lc = Boolean.parseBoolean(editTypeData[3]);
                            if (lc) {
                                String tlc = lineItem.toLowerCase();
                                sb.append("\"").append(tlc).append("\"");
                            } else {
                                sb.append("\"").append(lineItem).append("\"");
                            }
                        } else {
                            sb.append("\"").append(lineItem).append("\"");
                        }
                    } else if (editType.equals("autoincrement")) {
                        int startCount = Integer.parseInt(editTypeData[1]);
                        if (i == 0 && autoincrement == 0) {
                            autoincrement = startCount;
                        }
                        sb.append(autoincrement);
                        ++autoincrement;
                    } else if (editType.equals("constant")) {
                        String type = editTypeData[1];
                        if (type.equals("text")) {
                            sb.append("\"").append(editTypeData[2]).append("\"");
                        } else {
                            sb.append(editTypeData[2]);
                        }
                    }
                } else if (lineItem != null) {
                    if (columnTypes[i].endsWith("text")) {
                        sb.append("\"").append(lineItem).append("\"");
                    } else {
                        sb.append(lineItem);
                    }
                } else {
                    sb.append(lineItem);
                }
                if (i >= columns.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (iterator.hasNext()) {
                sb.append(",\n");
                continue;
            }
            if (withEndSemicolon) {
                sb.append(";\n");
                continue;
            }
            sb.append(",\n");
        }
        return sb;
    }
}

