/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.write;

import io.github.astrapi69.file.system.SystemPropertiesExtensions;
import io.github.astrapi69.string.CharsetExtensions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Optional;

public final class StoreFileExtensions {
    private StoreFileExtensions() {
    }

    public static void toFile(File file, byte[] data) throws IOException {
        Files.write(file.toPath(), data, new OpenOption[0]);
    }

    public static boolean toFile(File file, String stringToWrite) throws FileNotFoundException, IOException {
        return StoreFileExtensions.toFile(file, stringToWrite, (String)null);
    }

    public static boolean toFile(File file, Collection<String> lines) throws IOException {
        String sb = StoreFileExtensions.concatenate(lines);
        return StoreFileExtensions.toFile(file, sb);
    }

    private static String concatenate(Collection<String> lines) {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = SystemPropertiesExtensions.getLineSeparator();
        for (String line : lines) {
            sb.append(line);
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public static boolean toFile(File file, Collection<String> lines, String encoding) throws IOException {
        String sb = StoreFileExtensions.concatenate(lines);
        return StoreFileExtensions.toFile(file, sb, encoding);
    }

    public static boolean toFile(File file, Collection<String> lines, Charset charset) throws IOException {
        String sb = StoreFileExtensions.concatenate(lines);
        return StoreFileExtensions.toFile(file, sb, charset);
    }

    public static boolean toFile(File file, String stringToWrite, String encoding) throws FileNotFoundException, IOException {
        Optional optionalCharset = CharsetExtensions.getCharset((String)encoding);
        return optionalCharset.isPresent() ? StoreFileExtensions.toFile(file, stringToWrite, (Charset)optionalCharset.get()) : StoreFileExtensions.toFile(file, stringToWrite, (Charset)null);
    }

    public static boolean toFile(File file, String stringToWrite, Charset charset) throws FileNotFoundException, IOException {
        boolean written = false;
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             OutputStreamWriter osw = null == charset ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, charset);
             PrintWriter printWriter = new PrintWriter(osw);){
            printWriter.write(stringToWrite);
            written = true;
        }
        return written;
    }
}

