/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.copy;

import io.github.astrapi69.file.copy.CopyFileExtensions;
import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.exception.DirectoryAlreadyExistsException;
import io.github.astrapi69.file.exception.FileIsADirectoryException;
import io.github.astrapi69.file.exception.FileIsNotADirectoryException;
import io.github.astrapi69.file.exception.FileIsSecurityRestrictedException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class CopyDirectoryExtensions {
    private CopyDirectoryExtensions() {
    }

    public static boolean copyDirectory(final Path source, final Path destination) throws IOException {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(destination, "destination must not be null");
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source must be a directory: " + source);
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = destination.resolve(source.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destination.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    public static boolean copyDirectory(File source, File destination) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAlreadyExistsException {
        return CopyDirectoryExtensions.copyDirectory(source, destination, true);
    }

    public static boolean copyDirectory(File source, File destination, boolean lastModified) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAlreadyExistsException {
        return CopyDirectoryExtensions.copyDirectoryWithFileFilter(source, destination, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter fileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        return CopyDirectoryExtensions.copyDirectoryWithFileFilter(source, destination, fileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        return CopyDirectoryExtensions.copyDirectoryWithFileFilter(source, destination, includeFileFilter, excludeFileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, Collection<File> excludeFiles, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            DirectoryFactory.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = null != includeFileFilter ? source.listFiles(includeFileFilter) : source.listFiles();
        if (null != includeFilesArray) {
            ArrayList<File> allExcludeFilesList = null;
            if (null != excludeFileFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFileFilter);
                List<File> excludeFileFilterList = Arrays.asList(excludeFilesArray);
                allExcludeFilesList = new ArrayList<File>(excludeFileFilterList);
            }
            if (excludeFiles != null && !excludeFiles.isEmpty()) {
                if (allExcludeFilesList != null) {
                    allExcludeFilesList.addAll(excludeFiles);
                } else {
                    allExcludeFilesList = new ArrayList<File>(excludeFiles);
                }
            }
            if (null != allExcludeFilesList && !allExcludeFilesList.isEmpty()) {
                for (File currentFile : includeFilesArray) {
                    if (allExcludeFilesList.contains(currentFile)) continue;
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyDirectoryExtensions.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyDirectoryExtensions.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter filenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsSecurityRestrictedException {
        return CopyDirectoryExtensions.copyDirectoryWithFilenameFilter(source, destination, filenameFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            DirectoryFactory.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = null != includeFilenameFilter ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (null != includeFilesArray) {
            List<File> excludeFilesList = null;
            if (null != excludeFilenameFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File currentFile : includeFilesArray) {
                    if (excludeFilesList.contains(currentFile)) continue;
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyDirectoryExtensions.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyDirectoryExtensions.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }
}

