/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.copy;

import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.exception.FileIsNotADirectoryException;
import io.github.astrapi69.io.StreamExtensions;
import io.github.astrapi69.io.file.FileExtension;
import io.github.astrapi69.io.file.FileSize;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;

public final class CopyFileExtensions {
    private CopyFileExtensions() {
    }

    public static boolean copyFile(Path source, Path destination) throws IOException {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(destination, "destination must not be null");
        if (Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source must be a file: " + source);
        }
        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    public static void copyFiles(Collection<Path> sources, Path destination) throws IOException {
        Objects.requireNonNull(sources, "sources must not be null");
        Objects.requireNonNull(destination, "destination must not be null");
        if (!Files.isDirectory(destination, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
        for (Path source : sources) {
            CopyFileExtensions.copyFile(source, destination.resolve(source.getFileName()));
        }
    }

    public static Path newBackupOf(Path file) throws IOException {
        Objects.requireNonNull(file, "file must not be null");
        Path backup = Paths.get(file.toString() + ".bak", new String[0]);
        CopyFileExtensions.copyFile(file, backup);
        return backup;
    }

    public static boolean copyFile(File source, File destination) throws IOException {
        return CopyFileExtensions.copyFile(source, destination, true);
    }

    public static boolean copyFile(File source, File destination, boolean lastModified) throws IOException {
        return CopyFileExtensions.copyFile(source, destination, null, null, lastModified);
    }

    public static boolean copyFile(File source, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) throws IOException {
        boolean copied;
        if (source.isDirectory()) {
            throw new IllegalArgumentException("The source File " + destination.getName() + " should be a File but is a Directory.");
        }
        if (destination.isDirectory()) {
            throw new IllegalArgumentException("The destination File " + destination.getName() + " should be a File but is a Directory.");
        }
        try (InputStream inputStream = StreamExtensions.getInputStream((File)source);
             InputStreamReader reader = sourceEncoding != null ? new InputStreamReader(inputStream, sourceEncoding) : new InputStreamReader(inputStream);
             OutputStream outputStream = StreamExtensions.getOutputStream((File)destination, (!destination.exists() ? 1 : 0) != 0);
             BufferedOutputStream bos = new BufferedOutputStream(outputStream);
             OutputStreamWriter writer = destinationEncoding != null ? new OutputStreamWriter((OutputStream)bos, destinationEncoding) : new OutputStreamWriter(bos);){
            int tmp;
            char[] charArray = new char[FileSize.DEFAULT_BLOCK_SIZE.getSize()];
            while ((tmp = reader.read(charArray)) > 0) {
                writer.write(charArray, 0, tmp);
            }
            copied = true;
        }
        if (lastModified) {
            destination.setLastModified(source.lastModified());
        }
        return copied;
    }

    public static void copyFiles(Collection<File> sources, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) {
        if (!destination.exists()) {
            DirectoryFactory.newDirectory(destination);
        }
        sources.forEach(RuntimeExceptionDecorator.decorate(file -> {
            File destinationFile = new File(destination, file.getName());
            CopyFileExtensions.copyFile(file, destinationFile, sourceEncoding, destinationEncoding, lastModified);
        }));
    }

    public static boolean copyFileToDirectory(File source, File destinationDir) throws FileIsNotADirectoryException, IOException {
        return CopyFileExtensions.copyFileToDirectory(source, destinationDir, true);
    }

    public static boolean copyFileToDirectory(File source, File destinationDir, boolean lastModified) throws FileIsNotADirectoryException, IOException {
        if (null == destinationDir) {
            throw new IllegalArgumentException("Destination must not be null");
        }
        if (!destinationDir.isDirectory()) {
            throw new FileIsNotADirectoryException("Destination File-object '" + destinationDir.getAbsolutePath() + "' is not a directory.");
        }
        File destinationFile = new File(destinationDir, source.getName());
        return CopyFileExtensions.copyFile(source, destinationFile, lastModified);
    }

    public static File newBackupOf(File file, Charset sourceEncoding, Charset destinationEncoding) throws IOException {
        File backup = new File(file.getAbsolutePath() + FileExtension.BACKUP.getExtension());
        CopyFileExtensions.copyFile(file, backup, sourceEncoding, destinationEncoding, true);
        return backup;
    }
}

