/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.copy.api;

import io.github.astrapi69.file.copy.CopyDirectoryExtensions;
import io.github.astrapi69.file.copy.CopyFileExtensions;
import io.github.astrapi69.file.exception.DirectoryAlreadyExistsException;
import io.github.astrapi69.file.exception.FileIsADirectoryException;
import io.github.astrapi69.file.exception.FileIsNotADirectoryException;
import io.github.astrapi69.file.exception.FileIsSecurityRestrictedException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;

public interface Copyable {
    default public boolean copyDirectory(Path source, Path destination) throws IOException {
        return CopyDirectoryExtensions.copyDirectory(source, destination);
    }

    default public boolean copyDirectory(File source, File destination) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAlreadyExistsException {
        return CopyDirectoryExtensions.copyDirectory(source, destination);
    }

    default public boolean copyFile(File source, File destination) throws IOException {
        return CopyFileExtensions.copyFile(source, destination);
    }

    default public void copyFiles(Collection<File> sources, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) {
        CopyFileExtensions.copyFiles(sources, destination, sourceEncoding, destinationEncoding, lastModified);
    }

    default public File newBackupOf(File file, Charset sourceEncoding, Charset destinationEncoding) throws IOException {
        return CopyFileExtensions.newBackupOf(file, sourceEncoding, destinationEncoding);
    }

    default public boolean copyFile(Path source, Path destination) throws IOException {
        return CopyFileExtensions.copyFile(source, destination);
    }

    default public void copyFiles(Collection<Path> sources, Path destination) throws IOException {
        CopyFileExtensions.copyFiles(sources, destination);
    }

    default public Path newBackupOf(Path path) throws IOException {
        return CopyFileExtensions.newBackupOf(path);
    }
}

