/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create;

import io.github.astrapi69.collection.array.ArrayExtensions;
import io.github.astrapi69.collection.list.ListFactory;
import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.create.model.FileContentInfo;
import java.io.File;
import java.util.Collection;
import java.util.List;

public final class DirectoryStructureFactory {
    private DirectoryStructureFactory() {
    }

    public static Collection<File> newDirectoryStructure(Collection<FileContentInfo> fileInfos) {
        List files = ListFactory.newArrayList((Object[])new File[0]);
        for (FileContentInfo fileContentInfo : fileInfos) {
            files.add(FileContentInfo.toFile(fileContentInfo));
        }
        return files;
    }

    public static Collection<File> newDirectoryStructure(File parentDirectory, Collection<String> filePaths) {
        List directories = ListFactory.newArrayList((Object[])new File[0]);
        if (parentDirectory.isDirectory()) {
            for (String filePath : filePaths) {
                directories.add(DirectoryFactory.newDirectory(parentDirectory, filePath));
            }
        }
        return directories;
    }

    public static Collection<File> newDirectoryStructure(String parentAbsolutePath, Collection<String> filePaths) {
        return DirectoryStructureFactory.newDirectoryStructure(DirectoryFactory.newDirectoryQuietly(parentAbsolutePath), filePaths);
    }

    public static Collection<File> newDirectoryStructure(File parentDirectory, String ... filePaths) {
        return DirectoryStructureFactory.newDirectoryStructure(parentDirectory, (Collection<String>)ArrayExtensions.toList((Object[])filePaths));
    }

    public static Collection<File> newDirectoryStructure(String parentAbsolutePath, String ... filePaths) {
        return DirectoryStructureFactory.newDirectoryStructure(DirectoryFactory.newDirectoryQuietly(parentAbsolutePath), (Collection<String>)ArrayExtensions.toList((Object[])filePaths));
    }
}

