/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create;

import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.create.model.FileCreationState;
import io.github.astrapi69.file.create.model.FileInfo;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public final class FileFactory {
    private FileFactory() {
    }

    public static FileCreationState newFile(File file) throws IOException {
        FileCreationState fileCreationState = FileCreationState.ALREADY_EXISTS;
        if (!file.exists()) {
            fileCreationState = FileCreationState.FAILED;
            if (DirectoryFactory.mkParentDirs(file) && file.createNewFile()) {
                fileCreationState = FileCreationState.CREATED;
            }
        }
        return fileCreationState;
    }

    public static FileCreationState newFileQuietly(File file) {
        return (FileCreationState)((Object)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(file)));
    }

    public static File newFile(String absolutePath) throws IOException {
        return FileFactory.newFile(absolutePath, false);
    }

    public static File newFileQuietly(String absolutePath) {
        return (File)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(absolutePath));
    }

    public static File newFile(String absolutePath, boolean createIfNotExists) throws IOException {
        File file = new File(absolutePath);
        if (createIfNotExists) {
            FileFactory.newFile(file);
        }
        return file;
    }

    public static File newFileQuietly(String absolutePath, boolean createIfNotExists) {
        File file = new File(absolutePath);
        if (createIfNotExists) {
            FileFactory.newFileQuietly(file);
        }
        return file;
    }

    public static File newFile(File parentDirectory, String filename) throws IOException {
        if (parentDirectory.exists() && !parentDirectory.isDirectory()) {
            throw new RuntimeException("Given parent file is not a directory");
        }
        File file = new File(parentDirectory, filename);
        FileFactory.newFile(file);
        return file;
    }

    public static File newFileQuietly(File parentDirectory, String filename) {
        return (File)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(parentDirectory, filename));
    }

    public static File newFile(String parentDirectory, String filename) throws IOException {
        File file = new File(parentDirectory, filename);
        FileFactory.newFile(file);
        return file;
    }

    public static File newFileQuietly(String parentDirectory, String filename) {
        return (File)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(parentDirectory, filename));
    }

    public static File newFile(FileInfo fileInfo) throws IOException {
        return FileFactory.newFile(fileInfo.getPath(), fileInfo.getName());
    }

    public static File newFileQuietly(FileInfo fileInfo) {
        return (File)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFile(fileInfo));
    }

    public static FileCreationState newFiles(Collection<File> files) throws IOException {
        FileCreationState created = FileCreationState.PENDING;
        for (File file : files) {
            created = FileFactory.newFile(file);
        }
        return created;
    }

    public static FileCreationState newFilesQuietly(Collection<File> files) {
        return (FileCreationState)((Object)RuntimeExceptionDecorator.decorate(() -> FileFactory.newFiles(files)));
    }
}

