/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.create.api;

import io.github.astrapi69.file.create.DirectoryFactory;
import io.github.astrapi69.file.create.FileFactory;
import io.github.astrapi69.file.create.model.FileCreationState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public interface Createable {
    default public Collection<FileCreationState> newDirectories(Collection<File> directories) {
        return DirectoryFactory.newDirectories(directories);
    }

    default public boolean newDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        return DirectoryFactory.newDirectories(dir, attrs);
    }

    default public boolean newDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        return DirectoryFactory.newDirectory(dir, attrs);
    }

    default public File newDirectory(String absolutePath) throws IOException {
        return DirectoryFactory.newDirectory(absolutePath);
    }

    default public FileCreationState newDirectory(File directory) {
        return DirectoryFactory.newDirectory(directory);
    }

    default public File newDirectory(File parentDirectory, String directoryName) {
        return DirectoryFactory.newDirectory(parentDirectory, directoryName);
    }

    default public boolean mkParentDirs(File file) {
        return DirectoryFactory.mkParentDirs(file);
    }

    default public FileCreationState newFile(File file) throws IOException {
        return FileFactory.newFile(file);
    }

    default public File newFile(String absolutePath) throws IOException {
        return FileFactory.newFile(absolutePath);
    }

    default public File newFile(String absolutePath, boolean createIfNotExists) throws IOException {
        return FileFactory.newFile(absolutePath, createIfNotExists);
    }

    default public File newFile(File parentDirectory, String filename) throws IOException {
        return FileFactory.newFile(parentDirectory, filename);
    }

    default public FileCreationState newFiles(Collection<File> files) throws IOException {
        return FileFactory.newFiles(files);
    }
}

