/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.delete;

import io.github.astrapi69.file.exception.DirectoryHasNoContentException;
import io.github.astrapi69.file.exception.FileDoesNotExistException;
import io.github.astrapi69.file.exception.FileIsNotADirectoryException;
import io.github.astrapi69.file.exception.FileIsSecurityRestrictedException;
import io.github.astrapi69.file.search.FileSearchExtensions;
import io.github.astrapi69.io.file.filter.PrefixFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class DeleteFileExtensions {
    private DeleteFileExtensions() {
    }

    public static Exception checkFile(File file) {
        Exception ex = null;
        if (!file.exists()) {
            String error = "The directory " + file + " does not exist";
            ex = new FileDoesNotExistException(error);
            return ex;
        }
        if (!file.isDirectory()) {
            String error = "The given file '" + file + "' is not a directory";
            ex = new FileIsNotADirectoryException(error);
            return ex;
        }
        if (!Files.isReadable(file.toPath()) || !Files.isWritable(file.toPath())) {
            String error = "The directory " + file + " is empty or security restricted";
            ex = new DirectoryHasNoContentException(error);
        }
        return ex;
    }

    public static void delete(Collection<File> files) throws IOException {
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                DeleteFileExtensions.delete(file);
            }
        }
    }

    public static boolean delete(File file) throws IOException {
        Objects.requireNonNull(file);
        if (file.isDirectory()) {
            DeleteFileExtensions.deleteAllFiles(file.toPath());
            return Files.deleteIfExists(file.toPath());
        }
        return Files.deleteIfExists(file.toPath());
    }

    public static void deleteAllFiles(Path dirPath) throws IOException {
        Files.walkFileTree(dirPath, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteAllFiles(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Exception ex = DeleteFileExtensions.checkFile(file);
        if (ex != null) {
            try {
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DeleteFileExtensions.deleteFiles(file);
        if (!file.delete()) {
            throw new IOException("Cannot delete the File " + file.getAbsolutePath() + ".");
        }
    }

    public static void deleteAllFilesWithSuffix(File directory, String theSuffix) throws IOException {
        List<File> files = FileSearchExtensions.findFiles(directory.getAbsolutePath(), new String[]{theSuffix});
        for (File file : files) {
            DeleteFileExtensions.deleteFile(file);
        }
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        DeleteFileExtensions.delete(fileToDelete);
    }

    public static void deleteFiles(File file) throws IOException {
        File[] ff = file.listFiles();
        if (ff != null) {
            for (File f : ff) {
                DeleteFileExtensions.delete(f);
            }
        }
    }

    public static void deleteFilesWithFileFilter(File sourceDir, FileFilter includeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFileFilter(sourceDir, includeFileFilter, null);
    }

    public static void deleteAllFilesWithPrefix(File sourceDir, String prefix) throws FileIsNotADirectoryException, FileIsSecurityRestrictedException, IOException {
        DeleteFileExtensions.deleteFilesWithFileFilter(sourceDir, (FileFilter)new PrefixFileFilter(prefix));
    }

    public static void deleteFilesWithFileFilter(File source, FileFilter includeFileFilter, FileFilter excludeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = null != includeFileFilter ? source.listFiles(includeFileFilter) : source.listFiles();
        if (null != includeFilesArray) {
            List<File> excludeFilesList = null;
            if (null != excludeFileFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFileFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File currentFile : includeFilesArray) {
                    if (excludeFilesList.contains(currentFile)) continue;
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFilenameFilter(source, includeFilenameFilter, null);
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = null != includeFilenameFilter ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (null != includeFilesArray) {
            List<File> excludeFilesList = null;
            if (null != excludeFilenameFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File currentFile : includeFilesArray) {
                    if (excludeFilesList.contains(currentFile)) continue;
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }
}

