/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.delete.api;

import io.github.astrapi69.file.delete.DeleteFileExtensions;
import io.github.astrapi69.file.exception.FileIsNotADirectoryException;
import io.github.astrapi69.file.exception.FileIsSecurityRestrictedException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;

public interface Erasable {
    default public Exception checkFile(File file) {
        return DeleteFileExtensions.checkFile(file);
    }

    default public void delete(Collection<File> files) throws IOException {
        DeleteFileExtensions.delete(files);
    }

    default public boolean delete(File file) throws IOException {
        return DeleteFileExtensions.delete(file);
    }

    default public void deleteAllFiles(Path dirPath) throws IOException {
        DeleteFileExtensions.deleteAllFiles(dirPath);
    }

    default public void deleteAllFiles(File file) throws IOException {
        DeleteFileExtensions.deleteAllFiles(file);
    }

    default public void deleteAllFilesWithSuffix(File directory, String theSuffix) throws IOException {
        DeleteFileExtensions.deleteAllFilesWithSuffix(directory, theSuffix);
    }

    default public void deleteFile(File fileToDelete) throws IOException {
        DeleteFileExtensions.deleteFile(fileToDelete);
    }

    default public void deleteFiles(File file) throws IOException {
        DeleteFileExtensions.deleteFiles(file);
    }

    default public void deleteFilesWithFileFilter(File sourceDir, FileFilter includeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFileFilter(sourceDir, includeFileFilter);
    }

    default public void deleteAllFilesWithPrefix(File sourceDir, String prefix) throws FileIsNotADirectoryException, FileIsSecurityRestrictedException, IOException {
        DeleteFileExtensions.deleteAllFilesWithPrefix(sourceDir, prefix);
    }

    default public void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFilenameFilter(source, includeFilenameFilter);
    }
}

