/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.read.api;

import io.github.astrapi69.file.read.ReadFileExtensions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public interface Readable {
    default public String fromFile(File file) throws IOException {
        return ReadFileExtensions.fromFile(file, StandardCharsets.UTF_8);
    }

    default public String fromFile(File file, Charset encoding) throws IOException {
        return ReadFileExtensions.fromFile(file, encoding);
    }

    default public String readHeadLine(String inputFile) throws FileNotFoundException, IOException {
        return ReadFileExtensions.readHeadLine(inputFile);
    }

    default public List<String> readAllLines(File input) throws IOException {
        return Files.readAllLines(input.toPath());
    }

    default public byte[] toByteArray(File tmpFile) throws IOException {
        return ReadFileExtensions.toByteArray(tmpFile);
    }

    default public byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    default public Byte[] toObject(byte[] byteArray) {
        return ArrayUtils.toObject((byte[])byteArray);
    }
}

