/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.rename.api;

import io.github.astrapi69.file.copy.CopyFileExtensions;
import io.github.astrapi69.file.delete.DeleteFileExtensions;
import io.github.astrapi69.file.exception.FileDoesNotExistException;
import io.github.astrapi69.file.exception.FileIsADirectoryException;
import io.github.astrapi69.file.search.FileSearchExtensions;
import io.github.astrapi69.io.file.FilenameExtensions;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public interface Renameable {
    default public String appendSystemTimeToFilename(File fileToRename) {
        return this.appendSystemTimeToFilename(fileToRename, null);
    }

    default public String appendSystemTimeToFilename(File fileToRename, Date add2Name) {
        String format = "HHmmssSSS";
        SimpleDateFormat df = new SimpleDateFormat("HHmmssSSS");
        String sysTime = add2Name != null ? df.format(add2Name) : df.format(new Date());
        String fileName = fileToRename.getName();
        int extIndex = fileName.lastIndexOf(".");
        String ext = fileName.substring(extIndex);
        String newName = fileName.substring(0, extIndex) + "_" + sysTime + ext;
        return newName;
    }

    default public List<File> changeAllFilenameSuffix(File file, String oldSuffix, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        ArrayList<File> notDeletedFiles = null;
        List<File> files = FileSearchExtensions.findFiles(file.getAbsolutePath(), new String[]{oldSuffix});
        for (File currentFile : files) {
            if (this.changeFilenameSuffix(currentFile, newSuffix, delete)) continue;
            if (notDeletedFiles == null) {
                notDeletedFiles = new ArrayList<File>();
            }
            notDeletedFiles.add(currentFile);
        }
        return notDeletedFiles;
    }

    default public boolean changeFilenameSuffix(File file, String newSuffix, boolean delete) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        if (!file.exists()) {
            throw new FileDoesNotExistException("The file " + file + " does not exist.");
        }
        String newFilename = FilenameExtensions.getFilenamePrefix((File)file) + newSuffix;
        return this.renameFile(file, new File(newFilename), delete);
    }

    default public boolean renameFile(File fileToRename, File newFileName, boolean delete) throws IOException, FileIsADirectoryException {
        boolean success = fileToRename.renameTo(newFileName);
        if (!success && delete) {
            CopyFileExtensions.copyFile(fileToRename, newFileName);
            DeleteFileExtensions.delete(fileToRename);
            success = true;
        }
        return success;
    }

    default public File renameFileWithSystemtime(File fileToRename) throws IOException, FileIsADirectoryException {
        String newFilenameWithSystemtime = this.appendSystemTimeToFilename(fileToRename);
        File fileWithNewName = new File(fileToRename.getParent(), newFilenameWithSystemtime);
        this.renameFile(fileToRename, fileWithNewName, true);
        return fileWithNewName;
    }

    default public boolean changeFilenameSuffix(File file, String newSuffix) throws IOException, FileDoesNotExistException, FileIsADirectoryException {
        return this.changeFilenameSuffix(file, newSuffix, false);
    }

    default public boolean forceToMoveFile(File srcFile, File destinationFile) throws IOException, FileIsADirectoryException {
        return this.renameFile(srcFile, destinationFile, true);
    }

    default public boolean moveFile(File srcFile, File destDir) throws IOException, FileIsADirectoryException {
        return this.renameFile(srcFile, destDir, true);
    }

    default public boolean renameFile(File fileToRename, String newFileNameWithoutAbsolutePath) throws IOException, FileIsADirectoryException, FileDoesNotExistException {
        if (!fileToRename.exists()) {
            throw new FileDoesNotExistException("File " + fileToRename.getName() + " does not exist!");
        }
        String absolutePathPrefix = fileToRename.getParent();
        File newNameForFile = new File(absolutePathPrefix, newFileNameWithoutAbsolutePath);
        return this.renameFile(fileToRename, newNameForFile);
    }

    default public boolean renameFile(File fileToRename, File newFileName) throws IOException, FileIsADirectoryException {
        return this.renameFile(fileToRename, newFileName, false);
    }
}

