/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.search.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Searchable {
    default public File getRootDirectory(File file) {
        File previous = file;
        for (File parent = previous.getParentFile(); parent != null; parent = parent.getParentFile()) {
            previous = parent;
        }
        return previous;
    }

    default public boolean containsFile(File parent, File search) {
        String[] children = parent.list();
        if (children == null) {
            return false;
        }
        return Arrays.asList(children).contains(search.getName());
    }

    default public boolean containsFile(File parent, String pathname) {
        String[] allFiles = parent.list();
        if (allFiles == null) {
            return false;
        }
        return Arrays.asList(allFiles).contains(pathname);
    }

    default public Set<File> findFiles(File directory, Predicate<File> predicate) throws IOException {
        try (Stream<Path> pathStream = Files.list(directory.toPath());){
            Set<File> set = pathStream.map(Path::toFile).filter(predicate).collect(Collectors.toSet());
            return set;
        }
    }

    default public Set<File> findFilesRecursive(File directory, Predicate<File> predicate) throws IOException {
        try (Stream<Path> pathStream = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            Set<File> set = pathStream.map(Path::toFile).filter(predicate).collect(Collectors.toSet());
            return set;
        }
    }

    default public long countAllFilesInDirectory(File dir, long length, boolean includeDirectories) {
        File[] children = dir.listFiles();
        if (children == null || children.length < 1) {
            return length;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                if (includeDirectories) {
                    ++length;
                }
                length = this.countAllFilesInDirectory(child, length, includeDirectories);
                continue;
            }
            ++length;
        }
        return length;
    }

    default public List<File> findAllFiles(File dir, String fileSearchPattern) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        File[] children = dir.listFiles();
        if (children == null || children.length < 1) {
            return foundFiles;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                foundFiles.addAll(this.findAllFiles(child, fileSearchPattern));
                continue;
            }
            if (!child.getName().matches(fileSearchPattern)) continue;
            foundFiles.add(child);
        }
        return foundFiles;
    }

    default public List<File> findFiles(String start, String[] extensions) {
        ArrayList<File> files = new ArrayList<File>();
        File startDir = new File(start);
        if (!startDir.isDirectory()) {
            return files;
        }
        File[] children = startDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    files.addAll(this.findFiles(child.getAbsolutePath(), extensions));
                    continue;
                }
                if (!Arrays.stream(extensions).anyMatch(ext -> child.getName().endsWith((String)ext))) continue;
                files.add(child);
            }
        }
        return files;
    }

    default public List<File> getAllFilesFromDir(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) continue;
                files.add(child);
            }
        }
        return files;
    }

    default public List<File> getAllFilesFromDirRecursive(File dir) {
        return this.findAllFiles(dir, ".*");
    }

    default public List<File> findFilesWithPrefixAndExtensionRecursive(File dir, String prefix, String extension) {
        ArrayList<File> matchingFiles = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    matchingFiles.addAll(this.findFilesWithPrefixAndExtensionRecursive(file, prefix, extension));
                    continue;
                }
                if (!file.getName().startsWith(prefix) || !file.getName().endsWith("." + extension)) continue;
                matchingFiles.add(file);
            }
        }
        return matchingFiles;
    }
}

