/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.file.write.api;

import io.github.astrapi69.file.system.SystemPropertiesExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;

public interface Storable {
    default public void toFile(File file, byte[] data) throws IOException {
        Files.write(file.toPath(), data, new OpenOption[0]);
    }

    default public boolean toFile(File file, String stringToWrite) throws IOException {
        return this.toFile(file, stringToWrite, (Charset)null);
    }

    default public boolean toFile(File file, Collection<String> lines) throws IOException {
        String content = String.join((CharSequence)SystemPropertiesExtensions.getLineSeparator(), lines);
        return this.toFile(file, content);
    }

    default public boolean toFile(File file, Collection<String> lines, Charset charset) throws IOException {
        String content = String.join((CharSequence)SystemPropertiesExtensions.getLineSeparator(), lines);
        return this.toFile(file, content, charset);
    }

    default public boolean toFile(File file, String stringToWrite, Charset charset) throws IOException {
        Files.writeString(file.toPath(), (CharSequence)stringToWrite, charset != null ? charset : Charset.defaultCharset(), new OpenOption[0]);
        return true;
    }
}

