/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree;

import io.github.astrapi69.gen.tree.api.IBaseTreeNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;

public class BaseTreeNode<V, K>
implements IBaseTreeNode<V, K, BaseTreeNode<V, K>> {
    private K id;
    private V value;
    private Comparator<BaseTreeNode<V, K>> childComparator;
    private Collection<BaseTreeNode<V, K>> children;
    private String displayValue;
    private BaseTreeNode<V, K> parent;
    private boolean leaf;

    public BaseTreeNode(V value) {
        this.setValue(value);
    }

    public Collection<BaseTreeNode<V, K>> getChildren() {
        if (this.children == null) {
            this.children = new LinkedHashSet<BaseTreeNode<V, K>>();
        }
        return this.children;
    }

    @Override
    public void sortChildren() {
        if (this.childComparator != null) {
            this.children.stream().sorted(this.childComparator);
        }
    }

    protected BaseTreeNode(BaseTreeNodeBuilder<V, K, ?, ?> b) {
        this.id = b.id;
        this.value = b.value;
        this.childComparator = b.childComparator;
        this.children = b.children;
        this.displayValue = b.displayValue;
        this.parent = b.parent;
        this.leaf = b.leaf;
    }

    public static <V, K> BaseTreeNodeBuilder<V, K, ?, ?> builder() {
        return new BaseTreeNodeBuilderImpl();
    }

    public BaseTreeNodeBuilder<V, K, ?, ?> toBuilder() {
        return new BaseTreeNodeBuilderImpl().$fillValuesFrom(this);
    }

    public K getId() {
        return this.id;
    }

    public V getValue() {
        return this.value;
    }

    public Comparator<BaseTreeNode<V, K>> getChildComparator() {
        return this.childComparator;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public BaseTreeNode<V, K> getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setId(K id) {
        this.id = id;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setChildComparator(Comparator<BaseTreeNode<V, K>> childComparator) {
        this.childComparator = childComparator;
    }

    public void setChildren(Collection<BaseTreeNode<V, K>> children) {
        this.children = children;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public void setParent(BaseTreeNode<V, K> parent) {
        this.parent = parent;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public BaseTreeNode() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTreeNode)) {
            return false;
        }
        BaseTreeNode other = (BaseTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLeaf() != other.isLeaf()) {
            return false;
        }
        K this$id = this.getId();
        K other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Comparator<BaseTreeNode<V, K>> this$childComparator = this.getChildComparator();
        Comparator<BaseTreeNode<V, K>> other$childComparator = other.getChildComparator();
        if (this$childComparator == null ? other$childComparator != null : !((Object)this$childComparator).equals(other$childComparator)) {
            return false;
        }
        String this$displayValue = this.getDisplayValue();
        String other$displayValue = other.getDisplayValue();
        return !(this$displayValue == null ? other$displayValue != null : !this$displayValue.equals(other$displayValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseTreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLeaf() ? 79 : 97);
        K $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Comparator<BaseTreeNode<V, K>> $childComparator = this.getChildComparator();
        result = result * 59 + ($childComparator == null ? 43 : $childComparator.hashCode());
        String $displayValue = this.getDisplayValue();
        result = result * 59 + ($displayValue == null ? 43 : $displayValue.hashCode());
        return result;
    }

    public String toString() {
        return "BaseTreeNode(id=" + this.getId() + ", value=" + this.getValue() + ", childComparator=" + this.getChildComparator() + ", displayValue=" + this.getDisplayValue() + ", leaf=" + this.isLeaf() + ")";
    }

    private static final class BaseTreeNodeBuilderImpl<V, K>
    extends BaseTreeNodeBuilder<V, K, BaseTreeNode<V, K>, BaseTreeNodeBuilderImpl<V, K>> {
        private BaseTreeNodeBuilderImpl() {
        }

        @Override
        protected BaseTreeNodeBuilderImpl<V, K> self() {
            return this;
        }

        @Override
        public BaseTreeNode<V, K> build() {
            return new BaseTreeNode(this);
        }
    }

    public static abstract class BaseTreeNodeBuilder<V, K, C extends BaseTreeNode<V, K>, B extends BaseTreeNodeBuilder<V, K, C, B>> {
        private K id;
        private V value;
        private Comparator<BaseTreeNode<V, K>> childComparator;
        private Collection<BaseTreeNode<V, K>> children;
        private String displayValue;
        private BaseTreeNode<V, K> parent;
        private boolean leaf;

        protected B $fillValuesFrom(C instance) {
            BaseTreeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <V, K> void $fillValuesFromInstanceIntoBuilder(BaseTreeNode<V, K> instance, BaseTreeNodeBuilder<V, K, ?, ?> b) {
            b.id(instance.id);
            b.value(instance.value);
            b.childComparator(instance.childComparator);
            b.children(instance.children);
            b.displayValue(instance.displayValue);
            b.parent(instance.parent);
            b.leaf(instance.leaf);
        }

        public B id(K id) {
            this.id = id;
            return this.self();
        }

        public B value(V value) {
            this.value = value;
            return this.self();
        }

        public B childComparator(Comparator<BaseTreeNode<V, K>> childComparator) {
            this.childComparator = childComparator;
            return this.self();
        }

        public B children(Collection<BaseTreeNode<V, K>> children) {
            this.children = children;
            return this.self();
        }

        public B displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this.self();
        }

        public B parent(BaseTreeNode<V, K> parent) {
            this.parent = parent;
            return this.self();
        }

        public B leaf(boolean leaf) {
            this.leaf = leaf;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BaseTreeNode.BaseTreeNodeBuilder(id=" + this.id + ", value=" + this.value + ", childComparator=" + this.childComparator + ", children=" + this.children + ", displayValue=" + this.displayValue + ", parent=" + this.parent + ", leaf=" + this.leaf + ")";
        }
    }
}

