/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree;

import io.github.astrapi69.design.pattern.visitor.Acceptable;
import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.handler.SimpleTreeNodeHandlerExtensions;
import java.util.Collection;

public class SimpleTreeNode<V, K>
implements Acceptable<Visitor<SimpleTreeNode<V, K>>> {
    private K id;
    private SimpleTreeNode<V, K> parent;
    private SimpleTreeNode<V, K> leftMostChild;
    private SimpleTreeNode<V, K> rightSibling;
    private V value;
    private boolean leaf;

    public SimpleTreeNode(V value) {
        this.value = value;
    }

    public int getLevel() {
        return SimpleTreeNodeHandlerExtensions.getLevel(this);
    }

    public SimpleTreeNode<V, K> getRoot() {
        return SimpleTreeNodeHandlerExtensions.getRoot(this);
    }

    public boolean isRoot() {
        return SimpleTreeNodeHandlerExtensions.isRoot(this);
    }

    public boolean isNode() {
        return !this.isLeaf();
    }

    public Collection<SimpleTreeNode<V, K>> getAllSiblings() {
        return SimpleTreeNodeHandlerExtensions.getAllSiblings(this);
    }

    public Collection<SimpleTreeNode<V, K>> getAllLeftSiblings() {
        return SimpleTreeNodeHandlerExtensions.getAllLeftSiblings(this);
    }

    public Collection<SimpleTreeNode<V, K>> getAllRightSiblings() {
        return SimpleTreeNodeHandlerExtensions.getAllRightSiblings(this);
    }

    public boolean hasParent() {
        return SimpleTreeNodeHandlerExtensions.hasParent(this);
    }

    public boolean hasRightSibling() {
        return this.getRightSibling() != null;
    }

    public boolean hasLeftMostChild() {
        return this.getLeftMostChild() != null;
    }

    public Collection<SimpleTreeNode<V, K>> traverse() {
        return SimpleTreeNodeHandlerExtensions.traverse(this);
    }

    public Collection<SimpleTreeNode<V, K>> getChildren() {
        return SimpleTreeNodeHandlerExtensions.getChildren(this);
    }

    public void accept(Visitor<SimpleTreeNode<V, K>> visitor) {
        SimpleTreeNodeHandlerExtensions.accept(this, visitor);
    }

    protected SimpleTreeNode(SimpleTreeNodeBuilder<V, K, ?, ?> b) {
        this.id = b.id;
        this.parent = b.parent;
        this.leftMostChild = b.leftMostChild;
        this.rightSibling = b.rightSibling;
        this.value = b.value;
        this.leaf = b.leaf;
    }

    public static <V, K> SimpleTreeNodeBuilder<V, K, ?, ?> builder() {
        return new SimpleTreeNodeBuilderImpl();
    }

    public SimpleTreeNodeBuilder<V, K, ?, ?> toBuilder() {
        return new SimpleTreeNodeBuilderImpl().$fillValuesFrom(this);
    }

    public SimpleTreeNode() {
    }

    public K getId() {
        return this.id;
    }

    public SimpleTreeNode<V, K> getParent() {
        return this.parent;
    }

    public SimpleTreeNode<V, K> getLeftMostChild() {
        return this.leftMostChild;
    }

    public SimpleTreeNode<V, K> getRightSibling() {
        return this.rightSibling;
    }

    public V getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setId(K id) {
        this.id = id;
    }

    public void setParent(SimpleTreeNode<V, K> parent) {
        this.parent = parent;
    }

    public void setLeftMostChild(SimpleTreeNode<V, K> leftMostChild) {
        this.leftMostChild = leftMostChild;
    }

    public void setRightSibling(SimpleTreeNode<V, K> rightSibling) {
        this.rightSibling = rightSibling;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public String toString() {
        return "SimpleTreeNode(id=" + this.getId() + ", leftMostChild=" + this.getLeftMostChild() + ", rightSibling=" + this.getRightSibling() + ", value=" + this.getValue() + ", leaf=" + this.isLeaf() + ")";
    }

    private static final class SimpleTreeNodeBuilderImpl<V, K>
    extends SimpleTreeNodeBuilder<V, K, SimpleTreeNode<V, K>, SimpleTreeNodeBuilderImpl<V, K>> {
        private SimpleTreeNodeBuilderImpl() {
        }

        @Override
        protected SimpleTreeNodeBuilderImpl<V, K> self() {
            return this;
        }

        @Override
        public SimpleTreeNode<V, K> build() {
            return new SimpleTreeNode(this);
        }
    }

    public static abstract class SimpleTreeNodeBuilder<V, K, C extends SimpleTreeNode<V, K>, B extends SimpleTreeNodeBuilder<V, K, C, B>> {
        private K id;
        private SimpleTreeNode<V, K> parent;
        private SimpleTreeNode<V, K> leftMostChild;
        private SimpleTreeNode<V, K> rightSibling;
        private V value;
        private boolean leaf;

        protected B $fillValuesFrom(C instance) {
            SimpleTreeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <V, K> void $fillValuesFromInstanceIntoBuilder(SimpleTreeNode<V, K> instance, SimpleTreeNodeBuilder<V, K, ?, ?> b) {
            b.id(instance.id);
            b.parent(instance.parent);
            b.leftMostChild(instance.leftMostChild);
            b.rightSibling(instance.rightSibling);
            b.value(instance.value);
            b.leaf(instance.leaf);
        }

        public B id(K id) {
            this.id = id;
            return this.self();
        }

        public B parent(SimpleTreeNode<V, K> parent) {
            this.parent = parent;
            return this.self();
        }

        public B leftMostChild(SimpleTreeNode<V, K> leftMostChild) {
            this.leftMostChild = leftMostChild;
            return this.self();
        }

        public B rightSibling(SimpleTreeNode<V, K> rightSibling) {
            this.rightSibling = rightSibling;
            return this.self();
        }

        public B value(V value) {
            this.value = value;
            return this.self();
        }

        public B leaf(boolean leaf) {
            this.leaf = leaf;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "SimpleTreeNode.SimpleTreeNodeBuilder(id=" + this.id + ", parent=" + this.parent + ", leftMostChild=" + this.leftMostChild + ", rightSibling=" + this.rightSibling + ", value=" + this.value + ", leaf=" + this.leaf + ")";
        }
    }
}

