/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree;

import java.util.LinkedHashSet;
import java.util.Set;

public class TreeIdNode<T, K> {
    private static final long serialVersionUID = 1L;
    private K id;
    private K parentId;
    private Set<K> childrenIds;
    private String displayValue;
    private T value;
    private boolean leaf;

    public TreeIdNode(T value) {
        this.setValue(value);
    }

    public void addChild(TreeIdNode<T, K> child) {
        if (child != null && this.isNode()) {
            child.setParentId(this.id);
            this.getChildrenIds().add(child.getId());
        }
    }

    public int getChildCount() {
        return this.getChildrenIds().size();
    }

    public boolean hasChildren() {
        return this.getChildrenIds() != null && !this.getChildrenIds().isEmpty();
    }

    public boolean hasParent() {
        return this.getParentId() != null;
    }

    public boolean isNode() {
        return !this.isLeaf();
    }

    public boolean isRoot() {
        return !this.hasParent();
    }

    public void removeChild(TreeIdNode<T, K> child) {
        this.getChildrenIds().remove(child.getId());
        child.setParentId(null);
    }

    private static <T, K> Set<K> $default$childrenIds() {
        return new LinkedHashSet();
    }

    protected TreeIdNode(TreeIdNodeBuilder<T, K, ?, ?> b) {
        this.id = b.id;
        this.parentId = b.parentId;
        this.childrenIds = b.childrenIds$set ? b.childrenIds$value : TreeIdNode.$default$childrenIds();
        this.displayValue = b.displayValue;
        this.value = b.value;
        this.leaf = b.leaf;
    }

    public static <T, K> TreeIdNodeBuilder<T, K, ?, ?> builder() {
        return new TreeIdNodeBuilderImpl();
    }

    public TreeIdNodeBuilder<T, K, ?, ?> toBuilder() {
        return new TreeIdNodeBuilderImpl().$fillValuesFrom(this);
    }

    public TreeIdNode() {
        this.childrenIds = TreeIdNode.$default$childrenIds();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeIdNode)) {
            return false;
        }
        TreeIdNode other = (TreeIdNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLeaf() != other.isLeaf()) {
            return false;
        }
        K this$id = this.getId();
        K other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        K this$parentId = this.getParentId();
        K other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        Set<K> this$childrenIds = this.getChildrenIds();
        Set<K> other$childrenIds = other.getChildrenIds();
        if (this$childrenIds == null ? other$childrenIds != null : !((Object)this$childrenIds).equals(other$childrenIds)) {
            return false;
        }
        String this$displayValue = this.getDisplayValue();
        String other$displayValue = other.getDisplayValue();
        if (this$displayValue == null ? other$displayValue != null : !this$displayValue.equals(other$displayValue)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeIdNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLeaf() ? 79 : 97);
        K $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        K $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        Set<K> $childrenIds = this.getChildrenIds();
        result = result * 59 + ($childrenIds == null ? 43 : ((Object)$childrenIds).hashCode());
        String $displayValue = this.getDisplayValue();
        result = result * 59 + ($displayValue == null ? 43 : $displayValue.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "TreeIdNode(id=" + this.getId() + ", parentId=" + this.getParentId() + ", childrenIds=" + this.getChildrenIds() + ", displayValue=" + this.getDisplayValue() + ", value=" + this.getValue() + ", leaf=" + this.isLeaf() + ")";
    }

    public K getId() {
        return this.id;
    }

    public void setId(K id) {
        this.id = id;
    }

    public K getParentId() {
        return this.parentId;
    }

    public void setParentId(K parentId) {
        this.parentId = parentId;
    }

    public Set<K> getChildrenIds() {
        return this.childrenIds;
    }

    public void setChildrenIds(Set<K> childrenIds) {
        this.childrenIds = childrenIds;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    private static final class TreeIdNodeBuilderImpl<T, K>
    extends TreeIdNodeBuilder<T, K, TreeIdNode<T, K>, TreeIdNodeBuilderImpl<T, K>> {
        private TreeIdNodeBuilderImpl() {
        }

        @Override
        protected TreeIdNodeBuilderImpl<T, K> self() {
            return this;
        }

        @Override
        public TreeIdNode<T, K> build() {
            return new TreeIdNode(this);
        }
    }

    public static abstract class TreeIdNodeBuilder<T, K, C extends TreeIdNode<T, K>, B extends TreeIdNodeBuilder<T, K, C, B>> {
        private K id;
        private K parentId;
        private boolean childrenIds$set;
        private Set<K> childrenIds$value;
        private String displayValue;
        private T value;
        private boolean leaf;

        protected B $fillValuesFrom(C instance) {
            TreeIdNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T, K> void $fillValuesFromInstanceIntoBuilder(TreeIdNode<T, K> instance, TreeIdNodeBuilder<T, K, ?, ?> b) {
            b.id(instance.id);
            b.parentId(instance.parentId);
            b.childrenIds(instance.childrenIds);
            b.displayValue(instance.displayValue);
            b.value(instance.value);
            b.leaf(instance.leaf);
        }

        public B id(K id) {
            this.id = id;
            return this.self();
        }

        public B parentId(K parentId) {
            this.parentId = parentId;
            return this.self();
        }

        public B childrenIds(Set<K> childrenIds) {
            this.childrenIds$value = childrenIds;
            this.childrenIds$set = true;
            return this.self();
        }

        public B displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this.self();
        }

        public B value(T value) {
            this.value = value;
            return this.self();
        }

        public B leaf(boolean leaf) {
            this.leaf = leaf;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "TreeIdNode.TreeIdNodeBuilder(id=" + this.id + ", parentId=" + this.parentId + ", childrenIds$value=" + this.childrenIds$value + ", displayValue=" + this.displayValue + ", value=" + this.value + ", leaf=" + this.leaf + ")";
        }
    }
}

