/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree;

import io.github.astrapi69.gen.tree.api.ITreeNode;
import java.util.ArrayList;
import java.util.Collection;

public class TreeNode<T>
implements ITreeNode<T, TreeNode<T>> {
    private static final long serialVersionUID = 1L;
    private Collection<TreeNode<T>> children;
    private String displayValue;
    private TreeNode<T> parent;
    private T value;
    private boolean leaf;

    public TreeNode(T value) {
        this.setValue(value);
    }

    public Collection<TreeNode<T>> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode<T>>();
        }
        return this.children;
    }

    private static <T> Collection<TreeNode<T>> $default$children() {
        return new ArrayList<TreeNode<T>>();
    }

    protected TreeNode(TreeNodeBuilder<T, ?, ?> b) {
        this.children = b.children$set ? b.children$value : TreeNode.$default$children();
        this.displayValue = b.displayValue;
        this.parent = b.parent;
        this.value = b.value;
        this.leaf = b.leaf;
    }

    public static <T> TreeNodeBuilder<T, ?, ?> builder() {
        return new TreeNodeBuilderImpl();
    }

    public TreeNodeBuilder<T, ?, ?> toBuilder() {
        return new TreeNodeBuilderImpl().$fillValuesFrom(this);
    }

    public TreeNode() {
        this.children = TreeNode.$default$children();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLeaf() != other.isLeaf()) {
            return false;
        }
        String this$displayValue = this.getDisplayValue();
        String other$displayValue = other.getDisplayValue();
        if (this$displayValue == null ? other$displayValue != null : !this$displayValue.equals(other$displayValue)) {
            return false;
        }
        Object this$parent = this.getParent();
        Object other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLeaf() ? 79 : 97);
        String $displayValue = this.getDisplayValue();
        result = result * 59 + ($displayValue == null ? 43 : $displayValue.hashCode());
        Object $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "TreeNode(displayValue=" + this.getDisplayValue() + ", parent=" + (TreeNode)this.getParent() + ", value=" + this.getValue() + ", leaf=" + this.isLeaf() + ")";
    }

    public void setChildren(Collection<TreeNode<T>> children) {
        this.children = children;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    private static final class TreeNodeBuilderImpl<T>
    extends TreeNodeBuilder<T, TreeNode<T>, TreeNodeBuilderImpl<T>> {
        private TreeNodeBuilderImpl() {
        }

        @Override
        protected TreeNodeBuilderImpl<T> self() {
            return this;
        }

        @Override
        public TreeNode<T> build() {
            return new TreeNode(this);
        }
    }

    public static abstract class TreeNodeBuilder<T, C extends TreeNode<T>, B extends TreeNodeBuilder<T, C, B>> {
        private boolean children$set;
        private Collection<TreeNode<T>> children$value;
        private String displayValue;
        private TreeNode<T> parent;
        private T value;
        private boolean leaf;

        protected B $fillValuesFrom(C instance) {
            TreeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(TreeNode<T> instance, TreeNodeBuilder<T, ?, ?> b) {
            b.children(instance.children);
            b.displayValue(instance.displayValue);
            b.parent(instance.parent);
            b.value(instance.value);
            b.leaf(instance.leaf);
        }

        public B children(Collection<TreeNode<T>> children) {
            this.children$value = children;
            this.children$set = true;
            return this.self();
        }

        public B displayValue(String displayValue) {
            this.displayValue = displayValue;
            return this.self();
        }

        public B parent(TreeNode<T> parent) {
            this.parent = parent;
            return this.self();
        }

        public B value(T value) {
            this.value = value;
            return this.self();
        }

        public B leaf(boolean leaf) {
            this.leaf = leaf;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "TreeNode.TreeNodeBuilder(children$value=" + this.children$value + ", displayValue=" + this.displayValue + ", parent=" + this.parent + ", value=" + this.value + ", leaf=" + this.leaf + ")";
        }
    }
}

