/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.api;

import io.github.astrapi69.design.pattern.visitor.Acceptable;
import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.handler.ITreeNodeHandlerExtensions;
import io.github.astrapi69.gen.tree.handler.TreeNodeVisitorHandlerExtensions;
import io.github.astrapi69.tree.api.ITree;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public interface ITreeNode<V, T extends ITreeNode<V, T>>
extends ITree<V, T>,
Acceptable<Visitor<T>> {
    default public void addChild(T child) {
        ITreeNodeHandlerExtensions.addChild(this, child);
    }

    default public void addChild(T child, int index) {
        ITreeNodeHandlerExtensions.addChild(this, child, index);
    }

    default public Optional<T> getChildAt(int index) {
        return ITreeNodeHandlerExtensions.getChildAt(this, index);
    }

    default public int getChildIndex(T child) {
        return ITreeNodeHandlerExtensions.getChildIndex(this, child);
    }

    default public void addChildren(@NonNull Collection<T> children) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        ITreeNodeHandlerExtensions.addChildren(this, children);
    }

    default public Collection<T> getAllSiblings() {
        return ITreeNodeHandlerExtensions.getAllSiblings(this);
    }

    default public T getPreviousSibling() {
        return (T)ITreeNodeHandlerExtensions.getPreviousSibling(this);
    }

    default public T getNextSibling() {
        return (T)ITreeNodeHandlerExtensions.getNextSibling(this);
    }

    default public int getChildCount() {
        return this.getChildren().size();
    }

    default public int getLevel() {
        return ITreeNodeHandlerExtensions.getLevel(this);
    }

    default public T getRoot() {
        return (T)ITreeNodeHandlerExtensions.getRoot(this);
    }

    default public boolean hasChildren() {
        return ITreeNodeHandlerExtensions.hasChildren(this);
    }

    default public boolean hasNextSibling() {
        return ITreeNodeHandlerExtensions.hasNextSibling(this);
    }

    default public boolean hasParent() {
        return ITreeNodeHandlerExtensions.hasParent(this);
    }

    default public boolean hasPreviousSibling() {
        return ITreeNodeHandlerExtensions.hasPreviousSibling(this);
    }

    default public boolean isNode() {
        return !this.isLeaf();
    }

    default public boolean isRoot() {
        return ITreeNodeHandlerExtensions.isRoot(this);
    }

    default public void removeChild(T child) {
        ITreeNodeHandlerExtensions.removeChild(this, child);
    }

    default public boolean isChild(T child) {
        return ITreeNodeHandlerExtensions.isChild(this, child);
    }

    default public void clearChildren() {
        ITreeNodeHandlerExtensions.clearChildren(this);
    }

    default public void clearAll() {
        ITreeNodeHandlerExtensions.clearAll(this);
    }

    default public void removeChildren() {
        ITreeNodeHandlerExtensions.removeChildren(this);
    }

    default public void removeChildren(@NonNull Collection<T> children) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        ITreeNodeHandlerExtensions.removeChildren(this, children);
    }

    default public void accept(@NonNull Visitor<T> visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        TreeNodeVisitorHandlerExtensions.accept(this, visitor);
    }

    default public Collection<T> findAllByValue(V value) {
        return ITreeNodeHandlerExtensions.findAllByValue(this, value);
    }

    default public T findByValue(@NonNull V value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return (T)ITreeNodeHandlerExtensions.findByValue(this, value);
    }

    default public boolean contains(T treeNode) {
        return ITreeNodeHandlerExtensions.contains(this, treeNode);
    }

    default public boolean containsAll(@NonNull Collection<T> treeNodes) {
        if (treeNodes == null) {
            throw new NullPointerException("treeNodes is marked non-null but is null");
        }
        return ITreeNodeHandlerExtensions.containsAll(this, treeNodes);
    }

    default public List<T> toList() {
        return ITreeNodeHandlerExtensions.toList(this);
    }

    default public Collection<T> traverse() {
        return TreeNodeVisitorHandlerExtensions.traverse(this);
    }

    default public boolean isAncestor(T treeNode) {
        return ITreeNodeHandlerExtensions.isAncestor(this, treeNode);
    }

    default public boolean isDescendant(T treeNode) {
        return ITreeNodeHandlerExtensions.isDescendant(this, treeNode);
    }

    default public boolean move(T treeNode) {
        return ITreeNodeHandlerExtensions.move(this, treeNode);
    }
}

