/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.binary;

import io.github.astrapi69.gen.tree.binary.LinkedNode;
import java.util.Objects;

public abstract class GenericBinaryTree<T> {
    protected LinkedNode<T> first;

    public abstract boolean isSmaller(LinkedNode<T> var1, T var2);

    public abstract boolean isGreater(LinkedNode<T> var1, T var2);

    protected LinkedNode<T> addRecursively(LinkedNode<T> linkedNode, T value) {
        if (linkedNode == null) {
            return LinkedNode.builder().value(value).build();
        }
        if (this.isSmaller(linkedNode, value)) {
            LinkedNode<T> next = linkedNode.getNext();
            LinkedNode<T> nextLinkedNode = this.addRecursively(next, value);
            linkedNode.setNext(nextLinkedNode);
        } else if (this.isGreater(linkedNode, value)) {
            LinkedNode<T> previous = linkedNode.getPrevious();
            LinkedNode<T> previousLinkedNode = this.addRecursively(previous, value);
            linkedNode.setPrevious(previousLinkedNode);
        }
        return linkedNode;
    }

    public GenericBinaryTree<T> add(T value) {
        this.first = this.addRecursively(this.first, value);
        return this;
    }

    protected boolean containsRecursively(LinkedNode<T> linkedNode, T value) {
        if (linkedNode == null) {
            return false;
        }
        if (Objects.equals(value, linkedNode.getValue())) {
            return true;
        }
        return this.isSmaller(linkedNode, value) ? this.containsRecursively(linkedNode.getNext(), value) : this.containsRecursively(linkedNode.getPrevious(), value);
    }

    public boolean contains(T value) {
        return this.containsRecursively(this.first, value);
    }
}

