/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.binary;

import java.util.LinkedList;
import java.util.List;

public class LinkedNode<T> {
    private LinkedNode<T> next;
    private LinkedNode<T> previous;
    private T value;

    public LinkedNode(T value) {
        this.value = value;
    }

    public LinkedNode<T> getFirst() {
        LinkedNode<T> first = this;
        LinkedNode<T> previous = this.getPrevious();
        while (previous != null && !previous.isFirst()) {
            first = previous = previous.getPrevious();
        }
        return first;
    }

    public boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public int getNextCount() {
        return this.getNextLinkedNodes().size();
    }

    public List<LinkedNode<T>> getNextLinkedNodes() {
        LinkedList<LinkedNode<T>> list = new LinkedList<LinkedNode<T>>();
        LinkedNode<T> next = this;
        while (next.hasNext()) {
            next = next.getNext();
            list.add(next);
        }
        return list;
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public List<LinkedNode<T>> toList() {
        LinkedList<LinkedNode<T>> list = new LinkedList<LinkedNode<T>>();
        LinkedNode<T> first = this.getFirst();
        list.add(first);
        LinkedNode<T> next = first;
        while (next.hasNext()) {
            next = next.getNext();
            list.add(next);
        }
        return list;
    }

    public static <T> LinkedNodeBuilder<T> builder() {
        return new LinkedNodeBuilder();
    }

    public LinkedNodeBuilder<T> toBuilder() {
        return new LinkedNodeBuilder<T>().next(this.next).previous(this.previous).value(this.value);
    }

    public LinkedNode<T> getNext() {
        return this.next;
    }

    public LinkedNode<T> getPrevious() {
        return this.previous;
    }

    public T getValue() {
        return this.value;
    }

    public void setNext(LinkedNode<T> next) {
        this.next = next;
    }

    public void setPrevious(LinkedNode<T> previous) {
        this.previous = previous;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedNode)) {
            return false;
        }
        LinkedNode other = (LinkedNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LinkedNode<T> this$previous = this.getPrevious();
        LinkedNode<T> other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkedNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LinkedNode<T> $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "LinkedNode(previous=" + this.getPrevious() + ", value=" + this.getValue() + ")";
    }

    public LinkedNode() {
    }

    public LinkedNode(LinkedNode<T> next, LinkedNode<T> previous, T value) {
        this.next = next;
        this.previous = previous;
        this.value = value;
    }

    public static class LinkedNodeBuilder<T> {
        private LinkedNode<T> next;
        private LinkedNode<T> previous;
        private T value;

        LinkedNodeBuilder() {
        }

        public LinkedNodeBuilder<T> next(LinkedNode<T> next) {
            this.next = next;
            return this;
        }

        public LinkedNodeBuilder<T> previous(LinkedNode<T> previous) {
            this.previous = previous;
            return this;
        }

        public LinkedNodeBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public LinkedNode<T> build() {
            return new LinkedNode<T>(this.next, this.previous, this.value);
        }

        public String toString() {
            return "LinkedNode.LinkedNodeBuilder(next=" + this.next + ", previous=" + this.previous + ", value=" + this.value + ")";
        }
    }
}

