/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.convert;

import io.github.astrapi69.gen.tree.BaseTreeNode;
import io.github.astrapi69.gen.tree.TreeIdNode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class BaseTreeNodeTransformer {
    private BaseTreeNodeTransformer() {
    }

    public static <T, K> Map<K, TreeIdNode<T, K>> toKeyMap(@NonNull BaseTreeNode<T, K> root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return root.traverse().stream().collect(Collectors.toMap(BaseTreeNode::getId, BaseTreeNodeTransformer::toTreeIdNode, (first, second) -> first, LinkedHashMap::new));
    }

    public static <T, K> TreeIdNode<T, K> toTreeIdNode(@NonNull BaseTreeNode<T, K> baseTreeNode) {
        if (baseTreeNode == null) {
            throw new NullPointerException("baseTreeNode is marked non-null but is null");
        }
        return ((TreeIdNode.TreeIdNodeBuilder)((TreeIdNode.TreeIdNodeBuilder)((TreeIdNode.TreeIdNodeBuilder)((TreeIdNode.TreeIdNodeBuilder)((TreeIdNode.TreeIdNodeBuilder)((TreeIdNode.TreeIdNodeBuilder)TreeIdNode.builder().id(baseTreeNode.getId())).parentId(baseTreeNode.hasParent() ? (Object)((BaseTreeNode)baseTreeNode.getParent()).getId() : null)).value(baseTreeNode.getValue())).displayValue(baseTreeNode.getDisplayValue())).leaf(baseTreeNode.isLeaf())).childrenIds(baseTreeNode.getChildren().stream().map(BaseTreeNode::getId).collect(Collectors.toSet()))).build();
    }

    public static <T, K> Map<K, BaseTreeNode<T, K>> toKeyBaseTreeNodeMap(@NonNull BaseTreeNode<T, K> root) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return root.traverse().stream().collect(Collectors.toMap(BaseTreeNode::getId, element -> element, (first, second) -> first, LinkedHashMap::new));
    }

    public static <T, K> Map<K, BaseTreeNode<T, K>> transform(@NonNull Map<K, TreeIdNode<T, K>> treeIdNodeMap) {
        if (treeIdNodeMap == null) {
            throw new NullPointerException("treeIdNodeMap is marked non-null but is null");
        }
        Map baseTreeNodeMap = treeIdNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((BaseTreeNode.BaseTreeNodeBuilder)((BaseTreeNode.BaseTreeNodeBuilder)((BaseTreeNode.BaseTreeNodeBuilder)((BaseTreeNode.BaseTreeNodeBuilder)BaseTreeNode.builder().id(((TreeIdNode)entry.getValue()).getId())).value(((TreeIdNode)entry.getValue()).getValue())).displayValue(((TreeIdNode)entry.getValue()).getDisplayValue())).leaf(((TreeIdNode)entry.getValue()).isLeaf())).build(), (first, second) -> first, LinkedHashMap::new));
        for (Map.Entry<K, TreeIdNode<T, K>> entry2 : treeIdNodeMap.entrySet()) {
            K key = entry2.getKey();
            TreeIdNode<T, K> treeIdNode = entry2.getValue();
            BaseTreeNode baseTreeNode = (BaseTreeNode)baseTreeNodeMap.get(key);
            BaseTreeNode parent = treeIdNode.getParentId() != null ? (BaseTreeNode)baseTreeNodeMap.get(treeIdNode.getParentId()) : null;
            baseTreeNode.setParent(parent);
            Set children = treeIdNode.getChildrenIds().stream().map(baseTreeNodeMap::get).collect(Collectors.toSet());
            baseTreeNode.setChildren(children);
        }
        return baseTreeNodeMap;
    }

    public static <T, K> BaseTreeNode<T, K> getRoot(@NonNull Map<K, TreeIdNode<T, K>> treeIdNodeMap) {
        if (treeIdNodeMap == null) {
            throw new NullPointerException("treeIdNodeMap is marked non-null but is null");
        }
        AtomicReference root = new AtomicReference();
        if (treeIdNodeMap.isEmpty()) {
            return (BaseTreeNode)root.get();
        }
        BaseTreeNodeTransformer.transform(treeIdNodeMap).entrySet().stream().findAny().ifPresent(entry -> {
            BaseTreeNode any = (BaseTreeNode)entry.getValue();
            BaseTreeNode treeNode = (BaseTreeNode)any.getRoot();
            root.set(treeNode);
        });
        return (BaseTreeNode)root.get();
    }
}

