/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.handler;

import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.api.IBaseTreeNode;
import java.util.Collection;
import java.util.LinkedHashSet;
import lombok.NonNull;

public class BaseTreeNodeVisitorHandlerExtensions {
    public static <V, K, T extends IBaseTreeNode<V, K, T>> Collection<T> traverse(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet allTreeNodes = new LinkedHashSet();
        treeNode.accept(allTreeNodes::add);
        return allTreeNodes;
    }

    public static <V, K, T extends IBaseTreeNode<V, K, T>> void accept(@NonNull T treeNode, @NonNull Visitor<T> visitor) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        BaseTreeNodeVisitorHandlerExtensions.accept(treeNode, visitor, false);
    }

    public static <V, K, T extends IBaseTreeNode<V, K, T>> void accept(@NonNull T treeNode, @NonNull Visitor<T> visitor, boolean visitBefore) {
        boolean visitAfter;
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        boolean bl = visitAfter = !visitBefore;
        if (visitBefore) {
            visitor.visit(treeNode);
        }
        treeNode.getChildren().forEach(child -> BaseTreeNodeVisitorHandlerExtensions.accept(child, visitor, visitBefore));
        if (visitAfter) {
            visitor.visit(treeNode);
        }
    }
}

