/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.handler;

import io.github.astrapi69.gen.tree.api.IBaseTreeNode;
import io.github.astrapi69.gen.tree.visitor.MergeTreeNodesVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

public class IBaseTreeNodeHandlerExtensions {
    public static <V, K, T extends IBaseTreeNode<V, K, T>> T findById(@NonNull T treeNode, K id) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference<Boolean> stopSearch = new AtomicReference<Boolean>(Boolean.FALSE);
        AtomicReference found = new AtomicReference();
        treeNode.accept(currentTreeNode -> {
            if (!((Boolean)stopSearch.get()).booleanValue() && currentTreeNode.getId().equals(id)) {
                stopSearch.set(Boolean.TRUE);
                found.set(currentTreeNode);
            }
        });
        return (T)((IBaseTreeNode)found.get());
    }

    public static <V, K, T extends IBaseTreeNode<V, K, T>> T mergeTreeNodes(@NonNull T root, @NonNull List<T> treeNodes) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (treeNodes == null) {
            throw new NullPointerException("treeNodes is marked non-null but is null");
        }
        MergeTreeNodesVisitor visitor = new MergeTreeNodesVisitor(root);
        for (IBaseTreeNode treeNode : treeNodes) {
            treeNode.accept(visitor);
        }
        return root;
    }

    public static <V, K, T extends IBaseTreeNode<V, K, T>> T mergeTreeNodes(@NonNull T root, T ... treeNodes) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        return IBaseTreeNodeHandlerExtensions.mergeTreeNodes(root, Arrays.asList(treeNodes));
    }
}

