/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.handler;

import io.github.astrapi69.gen.tree.api.ITreeNode;
import io.github.astrapi69.gen.tree.handler.TreeNodeVisitorHandlerExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

public class ITreeNodeHandlerExtensions {
    public static <V, T extends ITreeNode<V, T>> Collection<T> getAllSiblings(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        ITreeNode parent = (ITreeNode)treeNode.getParent();
        if (parent == null) {
            return new LinkedHashSet();
        }
        LinkedHashSet allSiblings = new LinkedHashSet(parent.getChildren());
        allSiblings.remove(treeNode);
        return allSiblings;
    }

    public static <V, T extends ITreeNode<V, T>> T getRoot(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        Object root = treeNode;
        if (root.isRoot()) {
            return root;
        }
        while ((root = (ITreeNode)root.getParent()) != null && !root.isRoot()) {
        }
        return root;
    }

    public static <V, T extends ITreeNode<V, T>> T getNextSibling(@NonNull T currentTreeNode) {
        if (currentTreeNode == null) {
            throw new NullPointerException("currentTreeNode is marked non-null but is null");
        }
        ITreeNode next = null;
        if (currentTreeNode.getParent() == null) {
            return (T)next;
        }
        boolean isNext = false;
        for (ITreeNode treeNode : ((ITreeNode)currentTreeNode.getParent()).getChildren()) {
            if (isNext) {
                next = treeNode;
                break;
            }
            if (!treeNode.equals(currentTreeNode)) continue;
            isNext = true;
        }
        return (T)next;
    }

    public static <V, T extends ITreeNode<V, T>> T getPreviousSibling(@NonNull T currentTreeNode) {
        ITreeNode treeNode;
        if (currentTreeNode == null) {
            throw new NullPointerException("currentTreeNode is marked non-null but is null");
        }
        ITreeNode previous = null;
        if (currentTreeNode.getParent() == null) {
            return (T)previous;
        }
        Iterator iterator = ((ITreeNode)currentTreeNode.getParent()).getChildren().iterator();
        while (iterator.hasNext() && !(treeNode = (ITreeNode)iterator.next()).equals(currentTreeNode)) {
            previous = treeNode;
        }
        return (T)previous;
    }

    public static <V, T extends ITreeNode<V, T>> int getLevel(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        Object currentTreeNode = treeNode;
        int count = 0;
        while ((currentTreeNode = (ITreeNode)currentTreeNode.getParent()) != null) {
            ++count;
        }
        return count;
    }

    public static <V, T extends ITreeNode<V, T>> void removeChild(@NonNull T parentTreeNode, T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        ITreeNodeHandlerExtensions.removeChild(parentTreeNode, child, true);
    }

    public static <V, T extends ITreeNode<V, T>> void removeChild(@NonNull T parentTreeNode, T child, boolean clearChildren) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && ITreeNodeHandlerExtensions.isChildOf(parentTreeNode, child)) {
            parentTreeNode.getChildren().remove(child);
            child.setParent(null);
            if (clearChildren) {
                child.clearChildren();
            }
        }
    }

    public static <V, T extends ITreeNode<V, T>> boolean move(@NonNull T treeNodeToMove, T newParentTreeNode) {
        if (treeNodeToMove == null) {
            throw new NullPointerException("treeNodeToMove is marked non-null but is null");
        }
        if (newParentTreeNode != null && newParentTreeNode.isLeaf()) {
            return false;
        }
        if (ITreeNodeHandlerExtensions.isDescendant(treeNodeToMove, newParentTreeNode)) {
            return false;
        }
        if (treeNodeToMove.hasParent()) {
            ITreeNodeHandlerExtensions.removeChild((ITreeNode)treeNodeToMove.getParent(), treeNodeToMove, false);
        }
        newParentTreeNode.addChild(treeNodeToMove);
        return true;
    }

    public static <V, T extends ITreeNode<V, T>> boolean isChild(@NonNull T parentTreeNode, T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        return child != null && ITreeNodeHandlerExtensions.isChildOf(parentTreeNode, child);
    }

    public static <V, T extends ITreeNode<V, T>> boolean isChildOf(@NonNull T parentTreeNode, @NonNull T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        return parentTreeNode.getChildren().contains(child);
    }

    public static <V, T extends ITreeNode<V, T>> boolean isParentOf(@NonNull T parentTreeNode, @NonNull T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        return ((ITreeNode)child.getParent()).equals(parentTreeNode);
    }

    public static <V, T extends ITreeNode<V, T>> void removeChildren(@NonNull T parentTreeNode, @NonNull Collection<T> children) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        children.forEach(child -> ITreeNodeHandlerExtensions.removeChild(parentTreeNode, child));
    }

    public static <V, T extends ITreeNode<V, T>> void removeChildren(@NonNull T parentTreeNode) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        ITreeNodeHandlerExtensions.removeChildren(parentTreeNode, new ArrayList(parentTreeNode.getChildren()));
    }

    public static <V, T extends ITreeNode<V, T>> boolean isRoot(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return !ITreeNodeHandlerExtensions.hasParent(treeNode);
    }

    public static <V, T extends ITreeNode<V, T>> boolean hasNextSibling(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getNextSibling() != null;
    }

    public static <V, T extends ITreeNode<V, T>> boolean hasParent(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getParent() != null;
    }

    public static <V, T extends ITreeNode<V, T>> boolean hasPreviousSibling(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getPreviousSibling() != null;
    }

    public static <V, T extends ITreeNode<V, T>> boolean isNode(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return !treeNode.isLeaf();
    }

    public static <V, T extends ITreeNode<V, T>> void clearAll(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        treeNode.accept(ITreeNode::clearChildren);
    }

    public static <V, T extends ITreeNode<V, T>> void clearChildren(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        ITreeNodeHandlerExtensions.removeChildren(treeNode, new ArrayList(treeNode.getChildren()));
    }

    public static <V, T extends ITreeNode<V, T>> void addChild(@NonNull T parentTreeNode, T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && parentTreeNode.isNode()) {
            child.setParent(parentTreeNode);
            parentTreeNode.getChildren().add(child);
        }
    }

    public static <V, T extends ITreeNode<V, T>> void addChild(@NonNull T parentTreeNode, T child, int index) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && parentTreeNode.isNode()) {
            child.setParent(parentTreeNode);
            if (parentTreeNode.getChildren() instanceof List) {
                List children = (List)parentTreeNode.getChildren();
                children.add(index, child);
            } else {
                parentTreeNode.getChildren().add(child);
            }
        }
    }

    public static <V, T extends ITreeNode<V, T>> Optional<T> getChildAt(@NonNull T parentTreeNode, int index) {
        List children;
        ITreeNode child;
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (parentTreeNode.isNode() && parentTreeNode.getChildren() instanceof List && (child = (ITreeNode)(children = (List)parentTreeNode.getChildren()).get(index)) != null) {
            return Optional.of(child);
        }
        return Optional.empty();
    }

    public static <V, T extends ITreeNode<V, T>> int getChildIndex(@NonNull T parentTreeNode, T child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && parentTreeNode.isNode()) {
            child.setParent(parentTreeNode);
            if (parentTreeNode.getChildren() instanceof List) {
                List children = (List)parentTreeNode.getChildren();
                return children.indexOf(child);
            }
        }
        return -1;
    }

    public static <V, T extends ITreeNode<V, T>> void addChildren(@NonNull T parentTreeNode, @NonNull Collection<T> children) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (parentTreeNode.isNode()) {
            children.forEach(child -> ITreeNodeHandlerExtensions.addChild(parentTreeNode, child));
        }
    }

    public static <V, T extends ITreeNode<V, T>> int getChildCount(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getChildren().size();
    }

    public static <V, T extends ITreeNode<V, T>> boolean hasChildren(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getChildren() != null && !treeNode.getChildren().isEmpty();
    }

    public static <V, T extends ITreeNode<V, T>> Collection<T> traverse(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet allTreeNodes = new LinkedHashSet();
        treeNode.accept(allTreeNodes::add);
        return allTreeNodes;
    }

    public static <V, T extends ITreeNode<V, T>> Collection<T> findAllByValue(@NonNull T treeNode, V value) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference foundTreeNodes = new AtomicReference(new LinkedHashSet());
        treeNode.accept(currentTreeNode -> {
            if (value == null) {
                if (currentTreeNode != null && currentTreeNode.getValue() == null) {
                    ((Collection)foundTreeNodes.get()).add(currentTreeNode);
                }
            } else if (value.equals(currentTreeNode.getValue())) {
                ((Collection)foundTreeNodes.get()).add(currentTreeNode);
            }
        });
        return foundTreeNodes.get();
    }

    public static <V, T extends ITreeNode<V, T>> T findByValue(@NonNull T treeNode, V value) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference found = new AtomicReference();
        ITreeNodeHandlerExtensions.findAllByValue(treeNode, value).stream().findFirst().ifPresent(found::set);
        return (T)((ITreeNode)found.get());
    }

    public static <V, T extends ITreeNode<V, T>> boolean contains(@NonNull T treeNode, T descendantCandidate) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (descendantCandidate == null) {
            return false;
        }
        return TreeNodeVisitorHandlerExtensions.traverse(treeNode).contains(descendantCandidate);
    }

    public static <V, T extends ITreeNode<V, T>> boolean containsAll(@NonNull T treeNode, @NonNull Collection<T> treeNodes) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (treeNodes == null) {
            throw new NullPointerException("treeNodes is marked non-null but is null");
        }
        return TreeNodeVisitorHandlerExtensions.traverse(treeNode).containsAll(treeNodes);
    }

    public static <V, T extends ITreeNode<V, T>> List<T> toList(@NonNull T treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return new ArrayList<T>(TreeNodeVisitorHandlerExtensions.traverse(treeNode));
    }

    public static <V, T extends ITreeNode<V, T>> T findFirstOccurenceOfDescendant(@NonNull T treeNode, T possibleDescendant) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference<Boolean> stopSearch = new AtomicReference<Boolean>(Boolean.FALSE);
        AtomicReference found = new AtomicReference();
        treeNode.accept(currentTreeNode -> {
            if (!((Boolean)stopSearch.get()).booleanValue() && currentTreeNode.equals(possibleDescendant)) {
                stopSearch.set(Boolean.TRUE);
                found.set(currentTreeNode);
            }
        });
        return (T)((ITreeNode)found.get());
    }

    public static <V, T extends ITreeNode<V, T>> boolean isDescendant(@NonNull T treeNode, T possibleDescendant) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return ITreeNodeHandlerExtensions.findFirstOccurenceOfDescendant(treeNode, possibleDescendant) != null;
    }

    public static <V, T extends ITreeNode<V, T>> boolean isAncestor(@NonNull T treeNode, @NonNull T possibleAncestor) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (possibleAncestor == null) {
            throw new NullPointerException("possibleAncestor is marked non-null but is null");
        }
        for (ITreeNode parent = (ITreeNode)treeNode.getParent(); parent != null; parent = (ITreeNode)parent.getParent()) {
            if (parent != possibleAncestor) continue;
            return true;
        }
        return false;
    }
}

