/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.handler;

import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.SimpleTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

public class SimpleTreeNodeHandlerExtensions {
    public static <T, K> Collection<SimpleTreeNode<T, K>> getChildren(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet<SimpleTreeNode<T, K>> children = new LinkedHashSet<SimpleTreeNode<T, K>>();
        if (!treeNode.hasLeftMostChild()) {
            return children;
        }
        SimpleTreeNode<T, K> leftMostChild = treeNode.getLeftMostChild();
        children.add(leftMostChild);
        if (leftMostChild.hasRightSibling()) {
            SimpleTreeNode<T, K> currentRightSibling = leftMostChild.getRightSibling();
            children.add(currentRightSibling);
            do {
                currentRightSibling = currentRightSibling.getRightSibling();
                children.add(currentRightSibling);
            } while (currentRightSibling.hasRightSibling());
        }
        return children;
    }

    public static <T, K> Collection<SimpleTreeNode<T, K>> getAllSiblings(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        Collection<SimpleTreeNode<T, K>> allSiblings = new LinkedHashSet<SimpleTreeNode<T, K>>();
        if (treeNode.hasParent()) {
            allSiblings = SimpleTreeNodeHandlerExtensions.getChildren(treeNode.getParent());
        }
        return allSiblings;
    }

    public static <T, K> SimpleTreeNode<T, K> getRoot(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        SimpleTreeNode<T, K> root = treeNode;
        if (root.isRoot()) {
            return root;
        }
        while ((root = root.getParent()) != null && !root.isRoot()) {
        }
        return root;
    }

    public static <T, K> SimpleTreeNode<T, K> getNextSibling(@NonNull SimpleTreeNode<T, K> currentTreeNode) {
        if (currentTreeNode == null) {
            throw new NullPointerException("currentTreeNode is marked non-null but is null");
        }
        return currentTreeNode.getRightSibling();
    }

    public static <T, K> SimpleTreeNode<T, K> getPreviousSibling(@NonNull SimpleTreeNode<T, K> currentTreeNode) {
        if (currentTreeNode == null) {
            throw new NullPointerException("currentTreeNode is marked non-null but is null");
        }
        SimpleTreeNode<T, K> previous = null;
        if (currentTreeNode.getParent() == null) {
            return previous;
        }
        for (SimpleTreeNode<T, K> treeNode : currentTreeNode.getParent().getChildren()) {
            if (treeNode.equals(currentTreeNode)) break;
            previous = treeNode;
        }
        return previous;
    }

    public static <T, K> int getLevel(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        SimpleTreeNode<T, K> currentTreeNode = treeNode;
        int count = 0;
        while ((currentTreeNode = currentTreeNode.getParent()) != null) {
            ++count;
        }
        return count;
    }

    public static <T, K> void removeChild(@NonNull SimpleTreeNode<T, K> parentTreeNode, SimpleTreeNode<T, K> child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && SimpleTreeNodeHandlerExtensions.isChildOf(parentTreeNode, child)) {
            parentTreeNode.getChildren().remove(child);
            child.setParent(null);
            child.setLeftMostChild(null);
        }
    }

    public static <T, K> boolean isChildOf(@NonNull SimpleTreeNode<T, K> parentTreeNode, @NonNull SimpleTreeNode<T, K> child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        return parentTreeNode.getChildren().contains(child);
    }

    public static <T, K> boolean isParentOf(@NonNull SimpleTreeNode<T, K> parentTreeNode, @NonNull SimpleTreeNode<T, K> child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child == null) {
            throw new NullPointerException("child is marked non-null but is null");
        }
        return child.getParent().equals(parentTreeNode);
    }

    public static <T, K> void removeChildren(@NonNull SimpleTreeNode<T, K> parentTreeNode, @NonNull Collection<SimpleTreeNode<T, K>> children) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        children.forEach(child -> SimpleTreeNodeHandlerExtensions.removeChild(parentTreeNode, child));
    }

    public static <T, K> void removeChildren(@NonNull SimpleTreeNode<T, K> parentTreeNode) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        SimpleTreeNodeHandlerExtensions.removeChildren(parentTreeNode, new ArrayList<SimpleTreeNode<T, K>>(parentTreeNode.getChildren()));
    }

    public static <T, K> boolean isRoot(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return !treeNode.hasParent();
    }

    public static <T, K> boolean hasParent(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getParent() != null;
    }

    public static <T, K> boolean isNode(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return !treeNode.isLeaf();
    }

    public static <T, K> void clearAll(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        treeNode.accept(currentTreeNode -> currentTreeNode.setLeftMostChild(null));
    }

    public static <T, K> void clearChildren(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        SimpleTreeNodeHandlerExtensions.removeChildren(treeNode, new ArrayList<SimpleTreeNode<T, K>>(treeNode.getChildren()));
    }

    public static <T, K> void addChild(@NonNull SimpleTreeNode<T, K> parentTreeNode, SimpleTreeNode<T, K> child) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (child != null && parentTreeNode.isNode()) {
            child.setParent(parentTreeNode);
            parentTreeNode.getChildren().add(child);
        }
    }

    public static <T, K> void addChildren(@NonNull SimpleTreeNode<T, K> parentTreeNode, @NonNull Collection<SimpleTreeNode<T, K>> children) {
        if (parentTreeNode == null) {
            throw new NullPointerException("parentTreeNode is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (parentTreeNode.isNode()) {
            children.forEach(child -> SimpleTreeNodeHandlerExtensions.addChild(parentTreeNode, child));
        }
    }

    public static <T, K> int getChildCount(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getChildren().size();
    }

    public static <T, K> boolean hasChildren(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return treeNode.getChildren() != null && !treeNode.getChildren().isEmpty();
    }

    public static <T, K> Collection<SimpleTreeNode<T, K>> traverse(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet<SimpleTreeNode<T, K>> allTreeNodes = new LinkedHashSet<SimpleTreeNode<T, K>>();
        treeNode.accept(allTreeNodes::add);
        return allTreeNodes;
    }

    public static <T, K> void accept(@NonNull SimpleTreeNode<T, K> treeNode, @NonNull Visitor<SimpleTreeNode<T, K>> visitor) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        SimpleTreeNodeHandlerExtensions.accept(treeNode, visitor, true);
    }

    public static <T, K> void accept(@NonNull SimpleTreeNode<T, K> treeNode, @NonNull Visitor<SimpleTreeNode<T, K>> visitor, boolean visitBefore) {
        boolean visitAfter;
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (visitor == null) {
            throw new NullPointerException("visitor is marked non-null but is null");
        }
        boolean bl = visitAfter = !visitBefore;
        if (visitBefore) {
            visitor.visit(treeNode);
        }
        if (treeNode.hasLeftMostChild()) {
            treeNode.getLeftMostChild().accept(visitor);
        }
        if (treeNode.hasRightSibling()) {
            treeNode.getRightSibling().accept(visitor);
        }
        if (visitAfter) {
            visitor.visit(treeNode);
        }
    }

    public static <T, K> Collection<SimpleTreeNode<T, K>> findAllByValue(@NonNull SimpleTreeNode<T, K> treeNode, T value) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference foundTreeNodes = new AtomicReference(new LinkedHashSet());
        treeNode.accept(currentTreeNode -> {
            if (value == null) {
                if (currentTreeNode != null && currentTreeNode.getValue() == null) {
                    ((Collection)foundTreeNodes.get()).add(currentTreeNode);
                }
            } else if (value.equals(currentTreeNode.getValue())) {
                ((Collection)foundTreeNodes.get()).add(currentTreeNode);
            }
        });
        return foundTreeNodes.get();
    }

    public static <T, K> SimpleTreeNode<T, K> findByValue(@NonNull SimpleTreeNode<T, K> treeNode, T value) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        AtomicReference found = new AtomicReference();
        SimpleTreeNodeHandlerExtensions.findAllByValue(treeNode, value).stream().findFirst().ifPresent(currentTreeNode -> found.set(currentTreeNode));
        return (SimpleTreeNode)found.get();
    }

    public static <T, K> boolean contains(@NonNull SimpleTreeNode<T, K> treeNode, SimpleTreeNode<T, K> descendantCandidate) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (descendantCandidate == null) {
            return false;
        }
        return SimpleTreeNodeHandlerExtensions.traverse(treeNode).contains(descendantCandidate);
    }

    public static <T, K> boolean containsAll(@NonNull SimpleTreeNode<T, K> treeNode, @NonNull Collection<SimpleTreeNode<T, K>> treeNodes) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        if (treeNodes == null) {
            throw new NullPointerException("treeNodes is marked non-null but is null");
        }
        return SimpleTreeNodeHandlerExtensions.traverse(treeNode).containsAll(treeNodes);
    }

    public static <T, K> List<SimpleTreeNode<T, K>> toList(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        return new ArrayList<SimpleTreeNode<T, K>>(SimpleTreeNodeHandlerExtensions.traverse(treeNode));
    }

    public static <T, K> Collection<SimpleTreeNode<T, K>> getAllRightSiblings(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet<SimpleTreeNode<T, K>> allRightSiblings = new LinkedHashSet<SimpleTreeNode<T, K>>();
        if (treeNode.hasRightSibling()) {
            SimpleTreeNode<T, K> currentRightSibling;
            do {
                currentRightSibling = treeNode.getRightSibling();
                allRightSiblings.add(currentRightSibling);
            } while (currentRightSibling.hasRightSibling());
        }
        return allRightSiblings;
    }

    public static <T, K> Collection<SimpleTreeNode<T, K>> getAllLeftSiblings(@NonNull SimpleTreeNode<T, K> treeNode) {
        if (treeNode == null) {
            throw new NullPointerException("treeNode is marked non-null but is null");
        }
        LinkedHashSet<SimpleTreeNode<T, K>> allSiblings = new LinkedHashSet<SimpleTreeNode<T, K>>();
        if (treeNode.hasParent()) {
            SimpleTreeNode<T, K> parent = treeNode.getParent();
            SimpleTreeNode<T, K> leftMostChild = parent.getLeftMostChild();
            if (leftMostChild.equals(treeNode)) {
                return allSiblings;
            }
            allSiblings.add(leftMostChild);
            if (leftMostChild.hasRightSibling()) {
                SimpleTreeNode<T, K> currentRightSibling = leftMostChild.getRightSibling();
                if (currentRightSibling.equals(treeNode)) {
                    return allSiblings;
                }
                allSiblings.add(currentRightSibling);
                do {
                    if ((currentRightSibling = currentRightSibling.getRightSibling()).equals(treeNode)) {
                        return allSiblings;
                    }
                    allSiblings.add(currentRightSibling);
                } while (currentRightSibling.hasRightSibling());
            }
        }
        return allSiblings;
    }
}

