/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.visitor;

import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.api.IBaseTreeNode;
import io.github.astrapi69.gen.tree.merge.enumeration.MergeStrategy;
import lombok.NonNull;

public class BaseMergeTreeNodesVisitor<V, K, T extends IBaseTreeNode<V, K, T>>
implements Visitor<T> {
    private final T mergeWith;
    private final MergeStrategy mergeStrategy;

    public BaseMergeTreeNodesVisitor(@NonNull T mergeWith, @NonNull MergeStrategy mergeStrategy) {
        if (mergeWith == null) {
            throw new NullPointerException("mergeWith is marked non-null but is null");
        }
        if (mergeStrategy == null) {
            throw new NullPointerException("mergeStrategy is marked non-null but is null");
        }
        this.mergeWith = mergeWith;
        this.mergeStrategy = mergeStrategy;
    }

    public void visit(T treeNode) {
        Object byId = this.mergeWith.findById((Object)treeNode.getId());
        if (byId != null) {
            IBaseTreeNode parent = (IBaseTreeNode)byId.getParent();
            IBaseTreeNode treeNodeParent = (IBaseTreeNode)treeNode.getParent();
            switch (this.mergeStrategy) {
                case OVERWRITE: {
                    if (parent == null || !parent.equals(treeNodeParent)) break;
                    parent.addChild(treeNode);
                    break;
                }
                default: {
                    if (parent == null || !parent.equals(treeNodeParent) || parent.getChildren().contains(treeNode)) break;
                    parent.addChild(treeNode);
                }
            }
        }
    }
}

