/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.gen.tree.visitor;

import io.github.astrapi69.design.pattern.visitor.Visitor;
import io.github.astrapi69.gen.tree.api.IBaseTreeNode;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;

public class FindValuesIBaseTreeNodeVisitor<V, K, T extends IBaseTreeNode<V, K, T>>
implements Visitor<T> {
    private final AtomicReference<Collection<T>> foundTreeNodes = new AtomicReference(new LinkedHashSet());
    private final V value;

    public FindValuesIBaseTreeNodeVisitor(V value) {
        this.value = value;
    }

    public void visit(T treeNode) {
        if (this.value == null) {
            if (treeNode != null && treeNode.getValue() == null) {
                this.foundTreeNodes.get().add(treeNode);
            }
        } else if (this.value.equals(treeNode.getValue())) {
            this.foundTreeNodes.get().add(treeNode);
        }
    }

    public AtomicReference<Collection<T>> getFoundTreeNodes() {
        return this.foundTreeNodes;
    }

    public V getValue() {
        return this.value;
    }
}

