/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.jaxb;

import io.github.astrapi69.io.StringOutputStream;
import io.github.astrapi69.jaxb.factory.MarshallerFactory;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.OutputStream;
import lombok.NonNull;

public class ObjectToXmlExtensions {
    public static <T> String toXml(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Marshaller marshaller = MarshallerFactory.newPrettyPrintMarshaller(object);
        StringOutputStream outputStream = new StringOutputStream();
        RuntimeExceptionDecorator.decorate(() -> marshaller.marshal(object, (OutputStream)outputStream));
        return outputStream.toString();
    }

    public static <T> void toXml(@NonNull T object, @NonNull File file) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Marshaller marshaller = MarshallerFactory.newPrettyPrintMarshaller(object);
        RuntimeExceptionDecorator.decorate(() -> marshaller.marshal(object, file));
    }
}

